/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import lotr.common.recipe.AbstractAlloyForgeRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AlloyForgeRecipeSerializer<T extends AbstractAlloyForgeRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final IFactory<T> recipeFactory;
    private final int defaultCookingTime;

    public AlloyForgeRecipeSerializer(IFactory<T> factory, int time) {
        this.recipeFactory = factory;
        this.defaultCookingTime = time;
    }

    public T read(ResourceLocation recipeId, JsonObject json) {
        ItemStack result;
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        JsonArray jsonIngredient = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
        JsonArray jsonAlloy = JSONUtils.func_151202_d((JsonObject)json, (String)"alloy") ? JSONUtils.func_151214_t((JsonObject)json, (String)"alloy") : JSONUtils.func_152754_s((JsonObject)json, (String)"alloy");
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonIngredient);
        Ingredient alloy = Ingredient.func_199802_a((JsonElement)jsonAlloy);
        boolean swappable = json.get("swappable").getAsBoolean();
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (json.get("result").isJsonObject()) {
            result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        } else {
            String resultString = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
            ResourceLocation resultId = new ResourceLocation(resultString);
            result = new ItemStack((IItemProvider)Registry.field_212630_s.func_241873_b(resultId).orElseThrow(() -> new IllegalStateException("Item: " + resultString + " does not exist")));
        }
        float xp = JSONUtils.func_151221_a((JsonObject)json, (String)"experience", (float)0.0f);
        int time = JSONUtils.func_151208_a((JsonObject)json, (String)"cookingtime", (int)this.defaultCookingTime);
        return this.recipeFactory.create(recipeId, group, ingredient, alloy, swappable, result, xp, time);
    }

    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        String group = buffer.func_150789_c(Short.MAX_VALUE);
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        Ingredient alloy = Ingredient.func_199566_b((PacketBuffer)buffer);
        boolean swappable = buffer.readBoolean();
        ItemStack result = buffer.func_150791_c();
        float xp = buffer.readFloat();
        int time = buffer.func_150792_a();
        return this.recipeFactory.create(recipeId, group, ingredient, alloy, swappable, result, xp, time);
    }

    public void write(PacketBuffer buffer, T recipe) {
        buffer.func_180714_a(((AbstractAlloyForgeRecipe)recipe).group);
        ((AbstractAlloyForgeRecipe)recipe).ingredient.func_199564_a(buffer);
        ((AbstractAlloyForgeRecipe)recipe).alloyIngredient.func_199564_a(buffer);
        buffer.writeBoolean(((AbstractAlloyForgeRecipe)recipe).swappable);
        buffer.func_150788_a(((AbstractAlloyForgeRecipe)recipe).result);
        buffer.writeFloat(((AbstractAlloyForgeRecipe)recipe).experience);
        buffer.func_150787_b(((AbstractAlloyForgeRecipe)recipe).cookTime);
    }

    public static interface IFactory<T extends AbstractAlloyForgeRecipe> {
        public T create(ResourceLocation var1, String var2, Ingredient var3, Ingredient var4, boolean var5, ItemStack var6, float var7, int var8);
    }
}

