/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lotr.common.recipe.LOTRRecipes;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class DynamicIngredient
extends Ingredient {
    private final Type type;

    private DynamicIngredient(Type type) {
        super(type.getItemList());
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return LOTRRecipes.DYNAMIC_INGREDIENT_SERIALIZER;
    }

    public static class Serializer
    implements IIngredientSerializer {
        public Ingredient parse(JsonObject json) {
            if (!json.has("dynamic_type")) {
                throw new JsonSyntaxException("Missing dynamic_type, expected to find something here");
            }
            String typeName = json.get("dynamic_type").getAsString();
            Type type = Type.forCode(typeName);
            if (type != null) {
                return new DynamicIngredient(type);
            }
            throw new JsonSyntaxException("No dynamic_type named " + typeName + " exists");
        }

        public Ingredient parse(PacketBuffer buffer) {
            String typeName = buffer.func_218666_n();
            Type type = Type.forCode(typeName);
            if (type != null) {
                return new DynamicIngredient(type);
            }
            throw new JsonSyntaxException("No dynamic_type named " + typeName + " exists");
        }

        public void write(PacketBuffer buffer, Ingredient ingredient) {
            DynamicIngredient dynIng = (DynamicIngredient)ingredient;
            buffer.func_180714_a(dynIng.getType().getCode());
        }
    }

    public static enum Type {
        MEATS_EXCEPT_ROTTEN_FLESH("meats_except_rotten_flesh");

        private final String code;
        private ItemStack[] cachedItemStacks;

        private Type(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public static Type forCode(String code) {
            for (Type type : Type.values()) {
                if (!type.code.equals(code)) continue;
                return type;
            }
            return null;
        }

        public Stream<? extends Ingredient.IItemList> getItemList() {
            if (this.cachedItemStacks == null) {
                if (this == MEATS_EXCEPT_ROTTEN_FLESH) {
                    List<ItemStack> meats = ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.func_219971_r() && item.func_219967_s().func_221467_c() && item != Items.field_151078_bh).map(item -> new ItemStack((IItemProvider)item)).collect(Collectors.toList());
                    this.cachedItemStacks = meats.toArray(new ItemStack[0]);
                } else {
                    throw new IllegalArgumentException("Type " + this.code + " not yet implemented in code");
                }
            }
            return Arrays.stream(this.cachedItemStacks).map(stack -> new Ingredient.SingleItemList(stack));
        }
    }
}

