/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import lotr.common.LOTRLog;
import lotr.common.recipe.FactionBasedRecipeType;
import lotr.common.recipe.MultiTableType;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class FactionTableType
implements FactionBasedRecipeType<ICraftingRecipe> {
    public final ResourceLocation recipeTypeName;
    private final Supplier<Block> blockIconSupplier;
    private final List<MultiTableType> associatedMultiTableTypes = new ArrayList<MultiTableType>();
    @Deprecated
    public final String recipeID;

    public FactionTableType(ResourceLocation name, Supplier<Block> blockSup) {
        this.recipeTypeName = name;
        this.recipeID = this.recipeTypeName.toString();
        this.blockIconSupplier = blockSup;
    }

    public String toString() {
        return this.recipeTypeName.toString();
    }

    @Override
    public ItemStack getFactionTableIcon() {
        return new ItemStack((IItemProvider)this.blockIconSupplier.get());
    }

    @Deprecated
    public ItemStack getIcon() {
        return this.getFactionTableIcon();
    }

    protected void registerMultiTableType(MultiTableType t) {
        if (!t.includesFactionType(this)) {
            throw new IllegalArgumentException("Invalid - multi table type " + t.toString() + " does not include faction table " + this.toString() + "!");
        }
        if (!this.associatedMultiTableTypes.contains(t)) {
            this.associatedMultiTableTypes.add(t);
        } else {
            LOTRLog.warn("Faction table type %s already includes multi table type %s", this.toString(), t.toString());
        }
    }

    public List<MultiTableType> getMultiTableTypes() {
        return new ArrayList<MultiTableType>(this.associatedMultiTableTypes);
    }
}

