/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lotr.common.recipe.FactionBasedRecipeType;
import lotr.common.recipe.FactionTableType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.util.ResourceLocation;

public class MultiTableType
implements FactionBasedRecipeType<ICraftingRecipe> {
    public final ResourceLocation recipeTypeName;
    private final List<FactionTableType> tableTypes;
    private static final Random rand = new Random();
    private FactionTableType randTableType;
    private long lastRandomTime;

    public MultiTableType(ResourceLocation name, List<FactionTableType> types) {
        this.recipeTypeName = name;
        this.tableTypes = new ArrayList<FactionTableType>(types);
        for (FactionTableType facType : types) {
            facType.registerMultiTableType(this);
        }
    }

    public String toString() {
        return this.recipeTypeName.toString();
    }

    public boolean includesFactionType(FactionTableType type) {
        return this.tableTypes.contains(type);
    }

    @Override
    public ItemStack getFactionTableIcon() {
        if (this.randTableType == null || System.currentTimeMillis() - this.lastRandomTime > 1000L) {
            this.randTableType = this.tableTypes.get(rand.nextInt(this.tableTypes.size()));
            this.lastRandomTime = System.currentTimeMillis();
        }
        return this.randTableType.getFactionTableIcon();
    }
}

