/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.recipe;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lotr.common.fac.Faction;
import lotr.common.inv.FactionCraftingInventory;
import lotr.common.inv.PouchInventory;
import lotr.common.item.PouchItem;
import lotr.common.recipe.LOTRRecipes;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PouchRecipe
extends SpecialRecipe {
    private final IRecipeType<?> recipeType;

    public PouchRecipe(ResourceLocation id, IRecipeType<?> recipeType) {
        super(id);
        this.recipeType = recipeType;
    }

    public IRecipeType<?> func_222127_g() {
        return this.recipeType;
    }

    public boolean matches(CraftingInventory inv, World world) {
        return !this.getCraftingResult(inv).func_190926_b();
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack pouch;
        Optional tableColoringFaction = inv instanceof FactionCraftingInventory ? ((FactionCraftingInventory)inv).getPouchColoringFaction() : Optional.empty();
        ArrayList<ItemStack> pouches = new ArrayList<ItemStack>();
        int[] rgb = new int[3];
        int brightestIngredientColor = 0;
        int coloredItems = 0;
        boolean anyDye = false;
        boolean shouldApplyColorToResult = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack ingredient = inv.func_70301_a(i);
            if (ingredient.func_190926_b()) continue;
            Item ingredientItem = ingredient.func_77973_b();
            if (ingredientItem instanceof PouchItem) {
                pouches.add(ingredient);
                int pouchColor = PouchItem.getPouchColor(ingredient);
                float r = (float)(pouchColor >> 16 & 0xFF) / 255.0f;
                float g = (float)(pouchColor >> 8 & 0xFF) / 255.0f;
                float b = (float)(pouchColor & 0xFF) / 255.0f;
                brightestIngredientColor = (int)((float)brightestIngredientColor + Math.max(r, Math.max(g, b)) * 255.0f);
                rgb[0] = (int)((float)rgb[0] + r * 255.0f);
                rgb[1] = (int)((float)rgb[1] + g * 255.0f);
                rgb[2] = (int)((float)rgb[2] + b * 255.0f);
                ++coloredItems;
                if (!PouchItem.isPouchDyed(ingredient)) continue;
                shouldApplyColorToResult = true;
                continue;
            }
            if (ingredientItem instanceof DyeItem) {
                float[] dyeColors = ((DyeItem)ingredientItem).func_195962_g().func_193349_f();
                int r = (int)(dyeColors[0] * 255.0f);
                int g = (int)(dyeColors[1] * 255.0f);
                int b = (int)(dyeColors[2] * 255.0f);
                brightestIngredientColor += Math.max(r, Math.max(g, b));
                rgb[0] = rgb[0] + r;
                rgb[1] = rgb[1] + g;
                rgb[2] = rgb[2] + b;
                ++coloredItems;
                shouldApplyColorToResult = true;
                anyDye = true;
                continue;
            }
            return ItemStack.field_190927_a;
        }
        if (pouches.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        if (pouches.size() == 1) {
            if (!anyDye && !tableColoringFaction.isPresent()) {
                return ItemStack.field_190927_a;
            }
            pouch = ((ItemStack)pouches.get(0)).func_77946_l();
        } else {
            PouchItem combinedPouchItem = this.getCombinedPouchItem(pouches);
            if (combinedPouchItem == null) {
                return ItemStack.field_190927_a;
            }
            pouch = new ItemStack((IItemProvider)combinedPouchItem, 1);
            ArrayList<ItemStack> combinedContents = new ArrayList<ItemStack>();
            for (ItemStack craftingPouch : pouches) {
                PouchInventory craftingPouchInv = PouchInventory.temporaryReadOnly(craftingPouch);
                for (int i = 0; i < craftingPouchInv.func_70302_i_(); ++i) {
                    ItemStack slotItem = craftingPouchInv.func_70301_a(i);
                    if (slotItem.func_190926_b()) continue;
                    combinedContents.add(slotItem.func_77946_l());
                }
            }
            PouchInventory combinedPouchInv = PouchInventory.temporaryWritable(pouch);
            combinedPouchInv.fillPouchFromList(combinedContents);
            boolean pickedUpNewItems = pouches.stream().anyMatch(PouchItem::getPickedUpNewItems);
            PouchItem.setPickedUpNewItems(pouch, pickedUpNewItems);
        }
        if (tableColoringFaction.isPresent() && !anyDye) {
            PouchItem.setPouchDyedByFaction(pouch, (Faction)tableColoringFaction.get());
        } else if (shouldApplyColorToResult && coloredItems > 0) {
            int r = rgb[0] / coloredItems;
            int g = rgb[1] / coloredItems;
            int b = rgb[2] / coloredItems;
            float brightestIngredientColorPerItem = (float)brightestIngredientColor / (float)coloredItems;
            float brightestAvgIngredientRgb = Math.max(r, Math.max(g, b));
            r = (int)((float)r * brightestIngredientColorPerItem / brightestAvgIngredientRgb);
            g = (int)((float)g * brightestIngredientColorPerItem / brightestAvgIngredientRgb);
            b = (int)((float)b * brightestIngredientColorPerItem / brightestAvgIngredientRgb);
            int color = (r << 16) + (g << 8) + b;
            PouchItem.setPouchDyedByColor(pouch, color);
        }
        return pouch;
    }

    private PouchItem getCombinedPouchItem(List<ItemStack> pouches) {
        int totalCapacity = 0;
        for (ItemStack pouch : pouches) {
            Item item = pouch.func_77973_b();
            if (item instanceof PouchItem) {
                totalCapacity += ((PouchItem)item).getCapacity();
                continue;
            }
            return null;
        }
        return PouchItem.POUCHES_BY_CAPACITY.getOrDefault(totalCapacity, null);
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)LOTRRecipes.CRAFTING_SPECIAL_POUCH.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<PouchRecipe> {
        public PouchRecipe read(ResourceLocation recipeId, JsonObject json) {
            String recipeTypeName = JSONUtils.func_151219_a((JsonObject)json, (String)"table_type", (String)"");
            IRecipeType recipeType = LOTRRecipes.findRecipeTypeByNameOrThrow(recipeTypeName, IRecipeType.class);
            return new PouchRecipe(recipeId, recipeType);
        }

        public PouchRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            String recipeTypeName = buffer.func_150789_c(Short.MAX_VALUE);
            IRecipeType recipeType = LOTRRecipes.findRecipeTypeByNameOrThrow(recipeTypeName, IRecipeType.class);
            return new PouchRecipe(recipeId, recipeType);
        }

        public void write(PacketBuffer buffer, PouchRecipe recipe) {
            String recipeTypeName = LOTRRecipes.findRecipeTypeName(recipe.recipeType);
            buffer.func_211400_a(recipeTypeName, Short.MAX_VALUE);
        }
    }
}

