/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.resources;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.ResourceLocation;

public class DataDirectorySettings {
    public static final String SETTINGS_FILENAME = "_settings.json";
    private final Set<String> removeNamespaces;
    private final Set<ResourceLocation> removeResources;

    private DataDirectorySettings(Set<String> removeNamespaces, Set<ResourceLocation> removeResources) {
        this.removeNamespaces = removeNamespaces;
        this.removeResources = removeResources;
        this.validate();
    }

    private void validate() {
        this.removeNamespaces.forEach(namespace -> {
            if (ResourceLocation.func_208304_a((String)(namespace + ":test_resource_path")) == null) {
                throw new IllegalArgumentException("Invalid namespace declaration: " + namespace);
            }
        });
    }

    public static DataDirectorySettings empty() {
        return new DataDirectorySettings((Set<String>)ImmutableSet.of(), (Set<ResourceLocation>)ImmutableSet.of());
    }

    public static DataDirectorySettings read(ResourceLocation resourceName, JsonObject json) {
        HashSet<String> removeNamespaces = new HashSet<String>();
        JsonArray removeNamespacesArray = json.get("remove_namespaces").getAsJsonArray();
        for (JsonElement namespace : removeNamespacesArray) {
            removeNamespaces.add(namespace.getAsString());
        }
        HashSet<ResourceLocation> removeResources = new HashSet<ResourceLocation>();
        JsonArray removeResourcesArray = json.get("remove_singles").getAsJsonArray();
        for (JsonElement resource : removeResourcesArray) {
            removeResources.add(new ResourceLocation(resource.getAsString()));
        }
        return new DataDirectorySettings(removeNamespaces, removeResources);
    }

    public boolean shouldExclude(ResourceLocation resource) {
        return this.removeNamespaces.contains(resource.func_110624_b()) || this.removeResources.contains(resource);
    }

    public String toString() {
        return String.format("%s [removeNamespaces = %d, removeResources = %d]", SETTINGS_FILENAME, this.removeNamespaces.size(), this.removeResources.size());
    }
}

