/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.resources;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import lotr.common.LOTRLog;
import lotr.common.LOTRMod;
import lotr.common.resources.DataDirectorySettings;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.fml.packs.ResourcePackLoader;
import org.apache.commons.lang3.tuple.Pair;

public abstract class InstancedJsonReloadListener
extends JsonReloadListener {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected static final String JSON_EXTENSION = ".json";
    private final String rootFolder;
    protected final String loaderNameForLogging;
    protected final LogicalSide side;

    public InstancedJsonReloadListener(String folder, String name, LogicalSide side) {
        super(GSON, folder);
        this.rootFolder = folder;
        this.loaderNameForLogging = name;
        this.side = side;
    }

    public final LogicalSide getSide() {
        return this.side;
    }

    protected JsonObject loadDataJsonIfExists(Map<ResourceLocation, JsonElement> jsons, ResourceLocation targetPath) {
        Optional<Map.Entry> optEntry = jsons.entrySet().stream().filter(entry -> {
            ResourceLocation shortenedPath = (ResourceLocation)entry.getKey();
            return this.getPreparedPath(shortenedPath).equals((Object)targetPath);
        }).findFirst();
        if (optEntry.isPresent()) {
            return ((JsonElement)optEntry.get().getValue()).getAsJsonObject();
        }
        LOTRLog.error("%s datapack load missing %s", this.loaderNameForLogging, targetPath);
        return null;
    }

    protected Map<ResourceLocation, JsonObject> filterDataJsonsBySubFolder(Map<ResourceLocation, JsonElement> jsons, String subFolder) {
        Map<ResourceLocation, JsonObject> rootJsons = jsons.entrySet().stream().filter(e -> {
            ResourceLocation res = (ResourceLocation)e.getKey();
            String resPath = res.func_110623_a();
            return resPath.startsWith(subFolder) && !resPath.substring(subFolder.length()).contains("/");
        }).collect(InstancedJsonReloadListener.jsonElemToObjMapCollector());
        this.extractAndApplyDataDirectorySettings(rootJsons, subFolder);
        return rootJsons;
    }

    protected Map<ResourceLocation, JsonObject> filterDataJsonsByRootFolderOnly(Map<ResourceLocation, JsonElement> jsons) {
        Map<ResourceLocation, JsonObject> subJsons = jsons.entrySet().stream().filter(e -> {
            ResourceLocation res = (ResourceLocation)e.getKey();
            return !res.func_110623_a().contains("/");
        }).collect(InstancedJsonReloadListener.jsonElemToObjMapCollector());
        this.extractAndApplyDataDirectorySettings(subJsons, null);
        return subJsons;
    }

    private void extractAndApplyDataDirectorySettings(Map<ResourceLocation, JsonObject> jsons, String subFolder) {
        Map.Entry<ResourceLocation, JsonObject> settingsEntry = this.extractDataDirectorySettingsJson(jsons, subFolder);
        if (settingsEntry != null) {
            ResourceLocation settingsRes = settingsEntry.getKey();
            JsonObject settingsJson = settingsEntry.getValue();
            DataDirectorySettings settings = DataDirectorySettings.read(settingsRes, settingsJson);
            this.removeResourcesExcludedInSettings(jsons, subFolder, settings);
        }
    }

    private Map.Entry<ResourceLocation, JsonObject> extractDataDirectorySettingsJson(Map<ResourceLocation, JsonObject> jsons, String subFolder) {
        Optional<ResourceLocation> settingsResOpt = jsons.keySet().stream().filter(res -> this.getPreparedPath((ResourceLocation)res).func_110623_a().endsWith("/_settings.json")).findFirst();
        if (settingsResOpt.isPresent()) {
            ResourceLocation settingsRes = settingsResOpt.get();
            JsonObject settingsJson = jsons.remove(settingsRes);
            return Pair.of((Object)settingsRes, (Object)settingsJson);
        }
        return null;
    }

    private void removeResourcesExcludedInSettings(Map<ResourceLocation, JsonObject> jsons, String subFolder, DataDirectorySettings settings) {
        int sizeBefore = jsons.size();
        HashSet<ResourceLocation> toRemove = new HashSet<ResourceLocation>();
        for (ResourceLocation res : jsons.keySet()) {
            if (!settings.shouldExclude(InstancedJsonReloadListener.trimSubFolderResource(res, subFolder))) continue;
            toRemove.add(res);
        }
        toRemove.forEach(jsons::remove);
        int numRemoved = sizeBefore - jsons.size();
        LOTRLog.info("Excluded %d resources in folder '%s' based on the %s", numRemoved, this.getFullFolderName(subFolder), "_settings.json");
    }

    protected static ResourceLocation trimSubFolderResource(ResourceLocation res, String subFolder) {
        if (subFolder == null) {
            return res;
        }
        return new ResourceLocation(res.func_110624_b(), res.func_110623_a().substring(subFolder.length()));
    }

    protected Map<ResourceLocation, List<JsonObject>> loadJsonResourceVersionsFromAllDatapacks(Set<ResourceLocation> jsonPaths, IResourceManager resMgr) {
        return jsonPaths.stream().collect(Collectors.toMap(res -> res, res -> {
            ResourceLocation fullRes = this.getPreparedPath((ResourceLocation)res);
            try {
                return resMgr.func_199004_b(fullRes).stream().map(IResource::func_199027_b).map(is -> {
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
                    JsonElement json = (JsonElement)JSONUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonElement.class);
                    return json.getAsJsonObject();
                }).collect(Collectors.toList());
            }
            catch (Exception e) {
                LOTRLog.error("Couldn't parse datapack variant file %s from %s", res, fullRes);
                e.printStackTrace();
                return ImmutableList.of();
            }
        }));
    }

    protected Map<ResourceLocation, List<JsonObject>> asMapOfSingletonLists(Map<ResourceLocation, JsonObject> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ImmutableList.of(e.getValue())));
    }

    private String getFullFolderName(String subFolder) {
        return this.rootFolder + (subFolder == null ? "" : "/" + subFolder);
    }

    protected static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> toMapCollector() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    protected static Collector<Map.Entry<ResourceLocation, JsonElement>, ?, Map<ResourceLocation, JsonObject>> jsonElemToObjMapCollector() {
        return Collectors.toMap(Map.Entry::getKey, e -> ((JsonElement)e.getValue()).getAsJsonObject());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JsonObject loadDefaultJson(ResourceLocation res) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(InstancedJsonReloadListener.getDefaultDatapackResourceStream(res), StandardCharsets.UTF_8));){
            JsonObject jsonObj;
            JsonObject jsonObject = jsonObj = (JsonObject)JSONUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
            return jsonObject;
        }
        catch (Exception e) {
            LOTRLog.warn("Failed to parse %s json resource: %s", this.loaderNameForLogging, res);
            e.printStackTrace();
            return null;
        }
    }

    protected Map<ResourceLocation, JsonObject> loadDefaultJsonsInSubFolder(String subFolder, int maxDepth) {
        String fullFolder = String.format("%s/%s", this.rootFolder, subFolder);
        Collection<ResourceLocation> resources = InstancedJsonReloadListener.getDefaultDatapackResourcesInFolder(fullFolder, maxDepth, s -> s.endsWith(JSON_EXTENSION));
        Map<ResourceLocation, JsonObject> jsons = resources.stream().collect(Collectors.toMap(res -> {
            String resPath = res.func_110623_a();
            return new ResourceLocation(res.func_110624_b(), resPath.substring((this.rootFolder + "/").length(), resPath.indexOf(JSON_EXTENSION)));
        }, this::loadDefaultJson));
        this.extractDataDirectorySettingsJson(jsons, subFolder);
        return jsons;
    }

    private static InputStream getDefaultDatapackResourceStream(ResourceLocation res) {
        return LOTRMod.getDefaultModResourceStream(ResourcePackType.SERVER_DATA, res);
    }

    private static Collection<ResourceLocation> getDefaultDatapackResourcesInFolder(String path, int maxDepth, Predicate<String> filter) {
        String namespace = "lotr";
        ModFileResourcePack lotrAsPack = (ModFileResourcePack)ResourcePackLoader.getResourcePackFor((String)namespace).get();
        return lotrAsPack.func_225637_a_(ResourcePackType.SERVER_DATA, namespace, path, maxDepth, filter);
    }
}

