/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.speech;

import lotr.common.speech.NPCSpeechbankContext;
import lotr.common.speech.SpeechEnums;
import lotr.common.speech.SpeechbankContextSerializer;
import lotr.common.speech.condition.BiomeSpeechbankCondition;
import lotr.common.speech.condition.NullableResourceLocationSpeechbankCondition;
import lotr.common.speech.condition.PersonalitySpeechbankCondition;
import lotr.common.speech.condition.RankSpeechbankCondition;
import lotr.curuquesta.SpeechbankEngine;
import lotr.curuquesta.condition.BooleanSpeechbankCondition;
import lotr.curuquesta.condition.EnumSpeechbankCondition;
import lotr.curuquesta.condition.FloatRangeSpeechbankCondition;
import lotr.curuquesta.condition.FloatSpeechbankCondition;
import lotr.curuquesta.replaceablevar.ReplaceableSpeechVariable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.world.IDayTimeReader;

public class LOTRSpeechbankEngine {
    public static final SpeechbankEngine<NPCSpeechbankContext> INSTANCE = LOTRSpeechbankEngine.createEngine();
    public static final SpeechbankContextSerializer<NPCSpeechbankContext> SERIALIZER = new SpeechbankContextSerializer<NPCSpeechbankContext>(INSTANCE);

    private static SpeechbankEngine<NPCSpeechbankContext> createEngine() {
        return SpeechbankEngine.createInstance().registerCondition(EnumSpeechbankCondition.enumWithComparableExpressions((String)"day_or_night", (Enum[])SpeechEnums.DayOrNight.values(), context -> context.getWorld().func_72935_r() ? SpeechEnums.DayOrNight.DAY : SpeechEnums.DayOrNight.NIGHT)).registerCondition(new EnumSpeechbankCondition("daytime", (Enum[])SpeechEnums.Daytime.values(), context -> SpeechEnums.Daytime.getDaytime(context.getWorld()))).registerCondition(new FloatRangeSpeechbankCondition<NPCSpeechbankContext>("daytime_phase", context -> Float.valueOf(SpeechEnums.Daytime.getDaytimePhase(context.getWorld())), 0.0f, 1.0f)).registerCondition(new FloatRangeSpeechbankCondition<NPCSpeechbankContext>("hour", context -> Float.valueOf(SpeechEnums.Daytime.getHour(context.getWorld())), 0.0f, 24.0f)).registerCondition(new EnumSpeechbankCondition("weather", (Enum[])SpeechEnums.Weather.values(), context -> SpeechEnums.Weather.getWeather(context.getWorld(), context.getNPCBiome(), context.getNPCPosition()))).registerCondition(new BooleanSpeechbankCondition<NPCSpeechbankContext>("thunder", context -> SpeechEnums.Weather.isThundering(context.getWorld()))).registerCondition(EnumSpeechbankCondition.enumWithComparableExpressions((String)"moon_phase", (Enum[])SpeechEnums.MoonPhase.values(), context -> SpeechEnums.MoonPhase.getPhase((IDayTimeReader)context.getWorld()))).registerCondition(new BooleanSpeechbankCondition<NPCSpeechbankContext>("lunar_eclipse", context -> context.isLunarEclipse())).registerCondition(new FloatSpeechbankCondition<NPCSpeechbankContext>("align", context -> Float.valueOf(context.getPlayerAlignmentWithNPCFaction()))).registerCondition(new RankSpeechbankCondition<NPCSpeechbankContext>("rank", context -> context.getPlayerRankWithNPCFaction())).registerCondition(new EnumSpeechbankCondition("relation", (Enum[])SpeechEnums.Relation.values(), context -> context.getNPC().isFriendlyAndAligned(context.getPlayer()) ? SpeechEnums.Relation.FRIENDLY : SpeechEnums.Relation.HOSTILE)).registerCondition(new NullableResourceLocationSpeechbankCondition<NPCSpeechbankContext>("pledge", context -> context.getPledgeFactionName())).registerCondition(new EnumSpeechbankCondition("pledge_relation", (Enum[])SpeechEnums.PledgeRelation.values(), context -> context.getPledgeFactionRelation())).registerCondition(new EnumSpeechbankCondition("player_gender_pref", (Enum[])SpeechEnums.PreferredGender.values(), context -> SpeechEnums.PreferredGender.fromRankGender(context.getPreferredRankGender()))).registerCondition(new EnumSpeechbankCondition("gender", (Enum[])SpeechEnums.PreferredGender.values(), context -> SpeechEnums.PreferredGender.fromNPCGender(context.getNPC()))).registerCondition(new BooleanSpeechbankCondition<NPCSpeechbankContext>("can_trade", context -> context.getNPC().canTrade(context.getPlayer()))).registerCondition(new BooleanSpeechbankCondition<NPCSpeechbankContext>("in_combat", context -> context.getNPC().func_70638_az() != null)).registerCondition(new EnumSpeechbankCondition("in_conversation", (Enum[])SpeechEnums.InConversation.values(), context -> SpeechEnums.InConversation.getInConversationType(context.getNPC(), context.getPlayer()))).registerCondition(new BooleanSpeechbankCondition<NPCSpeechbankContext>("stargazing", context -> context.getNPC().isStargazing())).registerCondition(new BooleanSpeechbankCondition<NPCSpeechbankContext>("sun_admiring", context -> context.getNPC().isWatchingSunriseOrSunset())).registerCondition(new BooleanSpeechbankCondition<NPCSpeechbankContext>("fleeing", context -> context.getNPC().isFleeing())).registerCondition(new BiomeSpeechbankCondition<NPCSpeechbankContext>("biome", context -> context.getNPCBiomeWithTags())).registerCondition(new BooleanSpeechbankCondition<NPCSpeechbankContext>("underground", context -> context.isUnderground())).registerCondition(new BooleanSpeechbankCondition<NPCSpeechbankContext>("drunk", context -> context.isNPCDrunk())).registerCondition(new BooleanSpeechbankCondition<NPCSpeechbankContext>("player_drunk", context -> context.isPlayerDrunk())).registerCondition(new EnumSpeechbankCondition("hired", (Enum[])SpeechEnums.Hired.values(), context -> SpeechEnums.Hired.NONE)).registerCondition(new BooleanSpeechbankCondition<NPCSpeechbankContext>("mounted", context -> context.getNPC().func_184187_bx() != null)).registerCondition(new BooleanSpeechbankCondition<NPCSpeechbankContext>("player_mounted", context -> context.getPlayer().func_184187_bx() != null)).registerCondition(EnumSpeechbankCondition.enumWithComparableExpressions((String)"health", (Enum[])SpeechEnums.Health.values(), context -> SpeechEnums.Health.getHealth((LivingEntity)context.getNPC()))).registerCondition(EnumSpeechbankCondition.enumWithComparableExpressions((String)"player_health", (Enum[])SpeechEnums.Health.values(), context -> SpeechEnums.Health.getHealth((LivingEntity)context.getPlayer()))).registerCondition(EnumSpeechbankCondition.enumWithComparableExpressions((String)"player_hunger", (Enum[])SpeechEnums.Health.values(), context -> SpeechEnums.Health.getHealth(context.getPlayerHungerLevel()))).registerCondition(new PersonalitySpeechbankCondition<NPCSpeechbankContext>("personality", context -> context.getNPC().getPersonalInfo().getPersonalityTraits())).registerReplaceableVariable(new ReplaceableSpeechVariable<NPCSpeechbankContext>("p", "player", context -> context.getPlayer().func_200200_C_().getString()));
    }
}

