/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.speech;

import lotr.common.entity.npc.NPCEntity;
import lotr.common.fac.RankGender;
import lotr.common.init.LOTRBiomes;
import lotr.common.world.biome.ExtendedWeatherType;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeWrapper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IDayTimeReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class SpeechEnums {

    public static enum Health implements Comparable<Health>
    {
        DANGER,
        LOW,
        MEDIUM,
        HIGH,
        FULL;


        public static Health getHealth(LivingEntity e) {
            float healthF = e.func_110143_aJ() / e.func_110138_aP();
            return Health.getHealth(healthF);
        }

        public static Health getHealth(float frac) {
            if ((frac = MathHelper.func_76131_a((float)frac, (float)0.0f, (float)1.0f)) == 1.0f) {
                return FULL;
            }
            if (frac > 0.75f) {
                return HIGH;
            }
            if (frac > 0.5f) {
                return MEDIUM;
            }
            if (frac > 0.25f) {
                return LOW;
            }
            return DANGER;
        }
    }

    public static enum Hired {
        OWN,
        OTHER,
        NONE;

    }

    public static enum InConversation {
        NONE,
        SAME,
        OTHER;


        public static InConversation getInConversationType(NPCEntity npc, PlayerEntity player) {
            LivingEntity currentTalkingTo = npc.getTalkingToEntity();
            if (currentTalkingTo == null) {
                return NONE;
            }
            if (currentTalkingTo == player) {
                return SAME;
            }
            return OTHER;
        }
    }

    public static enum PreferredGender {
        M,
        F;


        public static PreferredGender fromRankGender(RankGender rankGender) {
            return rankGender == RankGender.FEMININE ? F : M;
        }

        public static PreferredGender fromNPCGender(NPCEntity npc) {
            return npc.getPersonalInfo().isMale() ? M : F;
        }
    }

    public static enum PledgeRelation {
        THIS,
        GOOD,
        NEUTRAL,
        BAD,
        NONE;

    }

    public static enum Relation {
        FRIENDLY,
        HOSTILE;

    }

    public static enum MoonPhase {
        FULL,
        WANING_GIBBOUS,
        THRID_QUARTER,
        WANING_CRESCENT,
        NEW,
        WAXING_CRESCENT,
        FIRST_QUARTER,
        WAXING_GIBBOUS;


        public static MoonPhase getPhase(IDayTimeReader world) {
            int phase = world.func_230315_m_().func_236035_c_(world.func_241851_ab());
            return MoonPhase.values()[MathHelper.func_76125_a((int)phase, (int)0, (int)(MoonPhase.values().length - 1))];
        }
    }

    public static enum Weather {
        CLEAR,
        RAIN,
        SNOW,
        ASH,
        SANDSTORM;


        public static Weather getWeather(World world, Biome biome, BlockPos pos) {
            if (world.func_72896_J()) {
                LOTRBiomeWrapper biomeWrapper = LOTRBiomes.getWrapperFor(biome, (IWorld)world);
                ExtendedWeatherType extendedWeather = biomeWrapper.getExtendedWeatherVisually();
                if (extendedWeather == ExtendedWeatherType.ASHFALL) {
                    return ASH;
                }
                if (extendedWeather == ExtendedWeatherType.SANDSTORM) {
                    return SANDSTORM;
                }
                if (LOTRBiomeBase.isSnowingVisually(biomeWrapper, (IWorld)world, pos)) {
                    return SNOW;
                }
                return RAIN;
            }
            return CLEAR;
        }

        public static boolean isThundering(World world) {
            return world.func_72911_I();
        }
    }

    public static enum Daytime {
        DAWN,
        MORNING,
        AFTERNOON,
        EVENING,
        DUSK,
        NIGHT;


        public static Daytime getDaytime(World world) {
            float phase = Daytime.getDaytimePhase(world);
            if (phase > 0.225f && phase < 0.265f) {
                return DAWN;
            }
            if (phase >= 0.265f && phase < 0.5f) {
                return MORNING;
            }
            if (phase >= 0.5f && phase < 0.68f) {
                return AFTERNOON;
            }
            if (phase >= 0.68f && phase < 0.735f) {
                return EVENING;
            }
            if (phase >= 0.735f && phase < 0.775f) {
                return DUSK;
            }
            return NIGHT;
        }

        public static float getDaytimePhase(World world) {
            float sunCycle = world.func_242415_f(1.0f);
            return (sunCycle + 0.5f) % 1.0f;
        }

        public static float getHour(World world) {
            return Daytime.getDaytimePhase(world) * 24.0f;
        }
    }

    public static enum DayOrNight {
        DAY,
        NIGHT;

    }
}

