/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.speech;

import io.netty.buffer.ByteBuf;
import lotr.common.LOTRLog;
import lotr.curuquesta.SpeechbankContext;
import lotr.curuquesta.SpeechbankContextProvider;
import lotr.curuquesta.SpeechbankEngine;
import lotr.curuquesta.condition.SpeechbankCondition;
import lotr.curuquesta.condition.SpeechbankConditionAndValue;
import lotr.curuquesta.replaceablevar.ReplaceableSpeechVariable;
import net.minecraft.network.PacketBuffer;

public class SpeechbankContextSerializer<C extends SpeechbankContextProvider> {
    private final SpeechbankEngine<C> engine;

    public SpeechbankContextSerializer(SpeechbankEngine<C> engine) {
        this.engine = engine;
    }

    public void write(SpeechbankContext<C> context, PacketBuffer buf) {
        buf.func_150787_b(context.getNumConditions());
        context.forEachCondition(conditionAndValue -> {
            buf.func_180714_a(conditionAndValue.getCondition().getConditionName());
            conditionAndValue.writeValue((ByteBuf)buf);
        });
        buf.func_150787_b(context.getNumReplaceableVariables());
        context.forEachReplaceableVariable((variable, value) -> {
            buf.func_180714_a(variable.getShortAlias());
            buf.func_180714_a(value);
        });
    }

    public SpeechbankContext<C> read(PacketBuffer buf) {
        SpeechbankContext<C> context = SpeechbankContext.newContext();
        int numConditions = buf.func_150792_a();
        for (int i = 0; i < numConditions; ++i) {
            String conditionName = buf.func_218666_n();
            SpeechbankCondition<?, C> condition = this.engine.getCondition(conditionName);
            if (condition == null) {
                LOTRLog.warn("Received speechbank context from server with an unknown condition name '%s! Exiting read now to prevent continuing to read malformed data", conditionName);
                return context;
            }
            SpeechbankConditionAndValue conditionAndValue = SpeechbankConditionAndValue.readValue(condition, (ByteBuf)buf);
            context.withCondition(conditionAndValue);
        }
        int numReplaceableVariables = buf.func_150792_a();
        for (int i = 0; i < numReplaceableVariables; ++i) {
            String shortAlias = buf.func_218666_n();
            String value = buf.func_218666_n();
            ReplaceableSpeechVariable<C> variable = this.engine.getReplaceableVariableByShortAlias(shortAlias);
            if (variable == null) {
                LOTRLog.warn("Received speechbank context from server with an unknown replaceable variable alias '%s'! Exiting read now to prevent continuing to read malformed data", shortAlias);
                return context;
            }
            context.withReplaceableVariable(variable, value);
        }
        return context;
    }
}

