/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.speech.condition;

import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import lotr.common.speech.condition.BiomeWithTags;
import lotr.curuquesta.SpeechbankContextProvider;
import lotr.curuquesta.condition.SpeechbankCondition;
import lotr.curuquesta.condition.predicate.ComplexPredicateParsers;
import lotr.curuquesta.condition.predicate.PredicateParser;

public class BiomeSpeechbankCondition<C extends SpeechbankContextProvider>
extends SpeechbankCondition<BiomeWithTags, C> {
    public static final String HOME = "#home";
    public static final String FOREIGN = "#foreign";

    public BiomeSpeechbankCondition(String conditionName, Function<C, BiomeWithTags> valueFromContext) {
        super(conditionName, valueFromContext, BiomeSpeechbankCondition.parsePredicate());
    }

    private static PredicateParser<BiomeWithTags> parsePredicate() {
        return ComplexPredicateParsers.logicalOrOfSubpredicates(elem -> {
            if (elem.equalsIgnoreCase(HOME)) {
                return BiomeWithTags::isHomeBiome;
            }
            if (elem.equalsIgnoreCase(FOREIGN)) {
                return BiomeWithTags::isForeignBiome;
            }
            return biomeWithTags -> biomeWithTags.getBiomeName().toString().equals(elem);
        });
    }

    @Override
    public boolean isValidValue(BiomeWithTags value) {
        return value != null;
    }

    @Override
    protected void writeValue(BiomeWithTags value, ByteBuf buf) {
        value.write(buf);
    }

    @Override
    protected BiomeWithTags readValue(ByteBuf buf) {
        return BiomeWithTags.read(buf);
    }
}

