/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.speech.condition;

import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import lotr.curuquesta.SpeechbankContextProvider;
import lotr.curuquesta.condition.SpeechbankCondition;
import lotr.curuquesta.condition.predicate.ComplexPredicateParsers;
import lotr.curuquesta.util.StringSerializer;
import net.minecraft.util.ResourceLocation;

public class NullableResourceLocationSpeechbankCondition<C extends SpeechbankContextProvider>
extends SpeechbankCondition<ResourceLocation, C> {
    public NullableResourceLocationSpeechbankCondition(String conditionName, Function<C, ResourceLocation> valueFromContext) {
        super(conditionName, valueFromContext, ComplexPredicateParsers.logicalOrOfValues(NullableResourceLocationSpeechbankCondition::parseNullableResourceLocation));
    }

    private static ResourceLocation parseNullableResourceLocation(String s) {
        return s == null ? null : new ResourceLocation(s);
    }

    @Override
    public boolean isValidValue(ResourceLocation value) {
        return true;
    }

    @Override
    protected void writeValue(ResourceLocation value, ByteBuf buf) {
        buf.writeBoolean(value != null);
        if (value != null) {
            StringSerializer.write(value.toString(), buf);
        }
    }

    @Override
    protected ResourceLocation readValue(ByteBuf buf) {
        boolean hasValue = buf.readBoolean();
        if (hasValue) {
            return new ResourceLocation(StringSerializer.read(buf));
        }
        return null;
    }
}

