/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.speech.condition;

import java.util.OptionalInt;
import lotr.common.LOTRLog;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionRank;
import lotr.curuquesta.condition.predicate.AsymmetricComparator;

public class OptionallyUnderspecifiedFactionRank {
    private final Faction faction;
    private final String rankName;

    private OptionallyUnderspecifiedFactionRank(Faction faction, String rankName) {
        this.faction = faction;
        this.rankName = rankName;
    }

    public static OptionallyUnderspecifiedFactionRank fullySpecified(FactionRank rank) {
        return new OptionallyUnderspecifiedFactionRank(rank.getFaction(), rank.getBaseName());
    }

    public static OptionallyUnderspecifiedFactionRank fullySpecified(Faction faction, String rankName) {
        if (faction == null) {
            throw new IllegalArgumentException("OptionallyUnderspecifiedFactionRank error - constructing a fully specified one, but faction is null!");
        }
        if (rankName == null) {
            throw new IllegalArgumentException("OptionallyUnderspecifiedFactionRank error - constructing a fully specified one, but rankName is null!");
        }
        return new OptionallyUnderspecifiedFactionRank(faction, rankName);
    }

    public static OptionallyUnderspecifiedFactionRank underspecified(String rankName) {
        if (rankName == null) {
            throw new IllegalArgumentException("OptionallyUnderspecifiedFactionRank error - constructing an underspecified one, but the rankName at least must be specified!");
        }
        return new OptionallyUnderspecifiedFactionRank(null, rankName);
    }

    public Faction getFaction() {
        return this.faction;
    }

    public String getRankName() {
        return this.rankName;
    }

    public boolean isUnderspecified() {
        return this.faction == null;
    }

    public FactionRank resolveRank() {
        if (this.isUnderspecified()) {
            throw new IllegalStateException("Cannot resolve the rank when it's underspecified! Development error.");
        }
        FactionRank rank = this.faction.getRankByName(this.rankName);
        if (rank == null) {
            throw new IllegalArgumentException("Could not resolve rank name " + this.rankName + " in faction " + this.faction.getName() + " - no such rank!");
        }
        return rank;
    }

    public static AsymmetricComparator<OptionallyUnderspecifiedFactionRank> asymmetricComparator() {
        return (rankInContext, rankInPredicate) -> {
            String rankInPredicateName;
            if (rankInContext.isUnderspecified()) {
                throw new IllegalArgumentException("The rank-in-context must be fully specified for this to work! Development error.");
            }
            Faction factionInContext = rankInContext.getFaction();
            if (factionInContext.getRankByName(rankInPredicateName = rankInPredicate.rankName) == null) {
                LOTRLog.debug("Speechbank entry refers to a rank '%s', but there is no such rank in the faction-in-context (%s). SpeechbankOverride is probably responsible here. This speechbank entry will be skipped.", rankInPredicateName, factionInContext.getName());
                return OptionalInt.empty();
            }
            OptionallyUnderspecifiedFactionRank fullySpecifiedRankInPredicate = OptionallyUnderspecifiedFactionRank.fullySpecified(factionInContext, rankInPredicateName);
            int rankComparison = rankInContext.resolveRank().compareTo(fullySpecifiedRankInPredicate.resolveRank());
            return OptionalInt.of(rankComparison);
        };
    }

    public String toString() {
        if (this.isUnderspecified()) {
            return String.format("%s (faction unspecified)", this.rankName);
        }
        return this.resolveRank().toString();
    }
}

