/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.speech.condition;

import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import java.util.function.Predicate;
import lotr.common.entity.npc.data.PersonalityTrait;
import lotr.common.entity.npc.data.PersonalityTraits;
import lotr.curuquesta.SpeechbankContextProvider;
import lotr.curuquesta.condition.SpeechbankCondition;
import lotr.curuquesta.condition.predicate.ComplexPredicateParsers;
import net.minecraft.network.PacketBuffer;

public class PersonalitySpeechbankCondition<C extends SpeechbankContextProvider>
extends SpeechbankCondition<PersonalityTraits, C> {
    public PersonalitySpeechbankCondition(String conditionName, Function<C, PersonalityTraits> valueFromContext) {
        super(conditionName, valueFromContext, ComplexPredicateParsers.logicalExpressionOfSubpredicates(PersonalitySpeechbankCondition::parsePersonalityPredicate));
    }

    private static Predicate<PersonalityTraits> parsePersonalityPredicate(String elem) {
        return personalityTraits -> {
            PersonalityTrait mainTrait = PersonalityTrait.fromMainName(elem);
            if (mainTrait != null) {
                return personalityTraits.hasTrait(mainTrait);
            }
            PersonalityTrait oppositeTrait = PersonalityTrait.fromOppositeName(elem);
            if (oppositeTrait != null) {
                return personalityTraits.hasOppositeTrait(oppositeTrait);
            }
            throw new IllegalArgumentException("Personality trait name '" + elem + "' does not refer to any known trait or opposite!");
        };
    }

    @Override
    public boolean isValidValue(PersonalityTraits value) {
        return value != null;
    }

    @Override
    protected void writeValue(PersonalityTraits value, ByteBuf buf) {
        value.write(new PacketBuffer(buf));
    }

    @Override
    protected PersonalityTraits readValue(ByteBuf buf) {
        return PersonalityTraits.read(new PacketBuffer(buf));
    }
}

