/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.time;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import lotr.common.LOTRLog;
import lotr.common.data.SaveUtil;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.SPacketLOTRTimeUpdate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class LOTRTime {
    public static final int DAY_FACTOR = 2;
    public static final long DAY_LENGTH = 48000L;
    private static long worldTime;
    private static long worldTimeClient;
    private static boolean needsLoad;

    private static File getTimeDat(ServerWorld world) {
        return new File(SaveUtil.getOrCreateLOTRDir(world), "LOTRTime.dat");
    }

    public static boolean needsLoad() {
        return needsLoad;
    }

    public static void resetNeedsLoad() {
        needsLoad = true;
    }

    public static void save(ServerWorld world) {
        try {
            File time_dat = LOTRTime.getTimeDat(world);
            if (!time_dat.exists()) {
                CompressedStreamTools.func_74799_a((CompoundNBT)new CompoundNBT(), (OutputStream)new FileOutputStream(time_dat));
            }
            CompoundNBT timeData = new CompoundNBT();
            timeData.func_74772_a("LOTRWorldTime", worldTime);
            SaveUtil.saveNBTToFile(time_dat, timeData);
        }
        catch (Exception e) {
            LOTRLog.error("Error saving world time");
            e.printStackTrace();
        }
    }

    public static void load(ServerWorld world) {
        try {
            CompoundNBT timeData = SaveUtil.loadNBTFromFile(LOTRTime.getTimeDat(world));
            worldTime = timeData.func_74763_f("LOTRWorldTime");
            needsLoad = false;
            LOTRTime.save(world);
        }
        catch (Exception e) {
            LOTRLog.error("Error loading LOTR time data");
            e.printStackTrace();
        }
    }

    public static long getWorldTime(IWorldReader world) {
        return LOTRTime.getWorldTime(world.func_201670_d());
    }

    public static long getWorldTime(boolean isRemote) {
        if (!isRemote) {
            return worldTime;
        }
        return worldTimeClient;
    }

    public static void setWorldTime(World world, long time) {
        if (!world.field_72995_K) {
            boolean bigChange;
            worldTime = time;
            long prevTime = LOTRTime.getWorldTime((IWorldReader)world);
            boolean bl = bigChange = Math.abs(worldTime - prevTime) >= 100L;
            if (worldTime % 20L == 0L || bigChange) {
                LOTRPacketHandler.sendToDimensionWorld(LOTRTime.createTimePacket(), world);
            }
        } else {
            worldTimeClient = time;
        }
    }

    public static void addWorldTime(World world, long time) {
        LOTRTime.setWorldTime(world, LOTRTime.getWorldTime((IWorldReader)world) + time);
    }

    public static void updateTime(World world_ME) {
        if (world_ME.func_82736_K().func_223586_b(GameRules.field_223607_j)) {
            LOTRTime.addWorldTime(world_ME, 1L);
        }
    }

    public static void advanceToMorning(ServerWorld world) {
        if (world.func_82736_K().func_223586_b(GameRules.field_223607_j)) {
            long l = worldTime + 48000L;
            LOTRTime.setWorldTime((World)world, l - l % 48000L);
        }
    }

    public static void sendLoginPacket(ServerPlayerEntity player) {
        LOTRPacketHandler.sendTo(LOTRTime.createTimePacket(), player);
    }

    private static SPacketLOTRTimeUpdate createTimePacket() {
        return new SPacketLOTRTimeUpdate(worldTime);
    }

    static {
        needsLoad = true;
    }
}

