/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.time;

import com.google.common.math.IntMath;
import lotr.common.time.MiddleEarthCalendar;
import lotr.common.time.Season;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ShireReckoning
extends MiddleEarthCalendar<ShireDate> {
    public static final ShireReckoning INSTANCE = new ShireReckoning();
    public static final ShireDate START_DATE = new ShireDate(1401, Month.HALIMATH, 22);

    @Override
    protected ShireDate computeDateForCache(int day) {
        ShireDate date = START_DATE.copy();
        if (day < 0) {
            for (int i = 0; i < -day; ++i) {
                date = date.decrement();
            }
        } else {
            for (int i = 0; i < day; ++i) {
                date = date.increment();
            }
        }
        return date;
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0;
    }

    public Season getSeason() {
        return ((ShireDate)this.getCurrentDate()).month.season;
    }

    public static class ShireDate
    extends MiddleEarthCalendar.AbstractDate {
        public final int year;
        public final Month month;
        public final int monthDate;
        private Day day;

        public ShireDate(int y, Month m, int d) {
            this.year = y;
            this.month = m;
            this.monthDate = d;
        }

        @Override
        protected ITextComponent getDateAndYearName(boolean shortform) {
            return new TranslationTextComponent("lotr.date.shire.format.dateAndYear", new Object[]{this.getDateName(shortform), this.getYearName(shortform)});
        }

        @Override
        protected ITextComponent getDateName(boolean shortform) {
            Day day = this.getDay();
            if (this.month.isSingleDay()) {
                if (this.month.hasWeekdayName) {
                    return new TranslationTextComponent("lotr.date.shire.format.weekdayOfSingleDayMonth", new Object[]{day.getDisplayName(), this.month.getDisplayName()});
                }
                return new TranslationTextComponent("lotr.date.shire.format.singleDayMonth", new Object[]{this.month.getDisplayName()});
            }
            return new TranslationTextComponent("lotr.date.shire.format.weekdayOfMonth", new Object[]{day.getDisplayName(), this.monthDate, this.month.getDisplayName()});
        }

        @Override
        protected ITextComponent getYearName(boolean shortform) {
            TranslationTextComponent yearPrefix = shortform ? new TranslationTextComponent("lotr.date.shire.short") : new TranslationTextComponent("lotr.date.shire.long");
            return new TranslationTextComponent("lotr.date.shire.format.year", new Object[]{yearPrefix, this.year});
        }

        public Day getDay() {
            if (!this.month.hasWeekdayName) {
                return null;
            }
            if (this.day == null) {
                int yearDay = 0;
                int monthID = this.month.ordinal();
                for (int i = 0; i < monthID; ++i) {
                    Month m = Month.values()[i];
                    if (!m.hasWeekdayName) continue;
                    yearDay += m.days;
                }
                int dayID = IntMath.mod((int)((yearDay += this.monthDate) - 1), (int)Day.values().length);
                this.day = Day.values()[dayID];
            }
            return this.day;
        }

        public ShireDate copy() {
            return new ShireDate(this.year, this.month, this.monthDate);
        }

        public ShireDate increment() {
            int newYear = this.year;
            Month newMonth = this.month;
            int newDate = this.monthDate;
            if (++newDate > newMonth.days) {
                newDate = 1;
                int monthID = newMonth.ordinal();
                if (++monthID >= Month.values().length) {
                    monthID = 0;
                    ++newYear;
                }
                newMonth = Month.values()[monthID];
                if (newMonth.isLeapYear && !ShireReckoning.isLeapYear(newYear)) {
                    newMonth = Month.values()[++monthID];
                }
            }
            return new ShireDate(newYear, newMonth, newDate);
        }

        public ShireDate decrement() {
            int newYear = this.year;
            Month newMonth = this.month;
            int newDate = this.monthDate;
            if (--newDate < 0) {
                int monthID = newMonth.ordinal();
                if (--monthID < 0) {
                    monthID = Month.values().length - 1;
                    --newYear;
                }
                newMonth = Month.values()[monthID];
                if (newMonth.isLeapYear && !ShireReckoning.isLeapYear(newYear)) {
                    newMonth = Month.values()[--monthID];
                }
                newDate = newMonth.days;
            }
            return new ShireDate(newYear, newMonth, newDate);
        }
    }

    public static enum Month {
        YULE_2("yule2", 1, Season.WINTER),
        AFTERYULE("afteryule", 30, Season.WINTER),
        SOLMATH("solmath", 30, Season.WINTER),
        RETHE("rethe", 30, Season.WINTER),
        ASTRON("astron", 30, Season.SPRING),
        THRIMIDGE("thrimidge", 30, Season.SPRING),
        FORELITHE("forelithe", 30, Season.SPRING),
        LITHE_1("lithe1", 1, Season.SPRING),
        MIDYEARSDAY("midyearsday", 1, Season.SUMMER, false, false),
        OVERLITHE("overlithe", 1, Season.SUMMER, false, true),
        LITHE_2("lithe2", 1, Season.SUMMER),
        AFTERLITHE("afterlithe", 30, Season.SUMMER),
        WEDMATH("wedmath", 30, Season.SUMMER),
        HALIMATH("halimath", 30, Season.SUMMER),
        WINTERFILTH("winterfilth", 30, Season.AUTUMN),
        BLOTMATH("blotmath", 30, Season.AUTUMN),
        FOREYULE("foreyule", 30, Season.AUTUMN),
        YULE_1("yule1", 1, Season.AUTUMN);

        private String name;
        public int days;
        public boolean hasWeekdayName;
        public boolean isLeapYear;
        public Season season;

        private Month(String s, int i, Season se) {
            this(s, i, se, true, false);
        }

        private Month(String s, int i, Season se, boolean flag, boolean flag1) {
            this.name = s;
            this.days = i;
            this.hasWeekdayName = flag;
            this.isLeapYear = flag1;
            this.season = se;
        }

        public ITextComponent getDisplayName() {
            return new TranslationTextComponent("lotr.date.shire.month." + this.name);
        }

        public boolean isSingleDay() {
            return this.days == 1;
        }
    }

    public static enum Day {
        STERDAY("sterday"),
        SUNDAY("sunday"),
        MONDAY("monday"),
        TREWSDAY("trewsday"),
        HEVENSDAY("hevensday"),
        MERSDAY("mersday"),
        HIGHDAY("highday");

        private String name;

        private Day(String s) {
            this.name = s;
        }

        public ITextComponent getDisplayName() {
            return new TranslationTextComponent("lotr.date.shire.day." + this.name);
        }
    }
}

