/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.util;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;

public class LazyReference<T> {
    private final ResourceLocation referenceName;
    private final Function<ResourceLocation, T> referenceResolver;
    private final Consumer<ResourceLocation> errorLoggerIfResolvingFails;
    private T resolvedReference;
    private boolean attemptedToResolve = false;

    private LazyReference(ResourceLocation name, Function<ResourceLocation, T> resolver, Consumer<ResourceLocation> errorLogger) {
        Objects.requireNonNull(name, "Reference name must not be null");
        Objects.requireNonNull(resolver, "Reference resolver function must not be null");
        Objects.requireNonNull(errorLogger, "Error logger also must not be null");
        this.referenceName = name;
        this.referenceResolver = resolver;
        this.errorLoggerIfResolvingFails = errorLogger;
    }

    public static <T> LazyReference<T> of(ResourceLocation name, Function<ResourceLocation, T> resolver, Consumer<ResourceLocation> errorLogger) {
        return new LazyReference<T>(name, resolver, errorLogger);
    }

    public T resolveReference() {
        if (!this.attemptedToResolve) {
            this.resolvedReference = this.referenceResolver.apply(this.referenceName);
            this.attemptedToResolve = true;
            if (this.resolvedReference == null) {
                this.errorLoggerIfResolvingFails.accept(this.referenceName);
            }
        }
        return this.resolvedReference;
    }

    public ResourceLocation getReferenceName() {
        return this.referenceName;
    }
}

