/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.ExtendedWeatherType;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.surface.SurfaceNoiseMixer;
import lotr.common.world.gen.feature.grassblend.GrassBlends;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.ParticleEffectAmbience;

public class DagorladBiome
extends LOTRBiomeBase {
    public DagorladBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.1f).func_205420_b(0.1f).func_205414_c(0.8f).func_205417_d(0.1f), major);
        this.biomeColors.setGrass(9208427);
        this.biomeColors.setSky(6181446);
        this.biomeColors.setClouds(0x333333);
        this.biomeColors.setFog(0x666666);
        this.biomeColors.setWater(2498845);
    }

    @Override
    protected void setupBiomeAmbience(BiomeAmbience.Builder builder) {
        super.setupBiomeAmbience(builder);
        builder.func_235244_a_(new ParticleEffectAmbience((IParticleData)ParticleTypes.field_239813_am_, 0.01f));
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setUnderwater(((Block)LOTRBlocks.MORDOR_GRAVEL.get()).func_176223_P());
        config.setSurfaceNoiseMixer(SurfaceNoiseMixer.createNoiseMixer(SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(1).scales(0.6, 0.09).threshold(0.3).state(Blocks.field_196660_k).topOnly(), SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(2).scales(0.6, 0.09).threshold(0.15).state(Blocks.field_150351_n).topOnly(), SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(3).scales(0.6, 0.09).threshold(0.1).state(LOTRBlocks.MORDOR_GRAVEL), SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(4).scales(0.6, 0.09).threshold(0.2).state(LOTRBlocks.MORDOR_DIRT)));
    }

    @Override
    protected void addBoulders(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 1, 2, 40, 3);
        LOTRBiomeFeatures.addBoulders(builder, ((Block)LOTRBlocks.MORDOR_DIRT.get()).func_176223_P(), 1, 4, 24, 2);
        LOTRBiomeFeatures.addBoulders(builder, ((Block)LOTRBlocks.MORDOR_GRAVEL.get()).func_176223_P(), 1, 4, 24, 2);
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addTreesIncrease(this, builder, 0, 0.0125f, 3, LOTRBiomeFeatures.charred(), 1);
        LOTRBiomeFeatures.addGrass(this, builder, 1, GrassBlends.BASIC);
        LOTRBiomeFeatures.addMordorGrass(builder, 1);
        LOTRBiomeFeatures.addDeadBushAtSurfaceChance(builder, 2);
    }

    @Override
    protected void addPumpkins(BiomeGenerationSettings.Builder builder) {
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
    }

    @Override
    protected ExtendedWeatherType getBiomeExtendedWeather() {
        return ExtendedWeatherType.ASHFALL;
    }

    @Override
    public Biome getRiver(IWorld world) {
        return null;
    }
}

