/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.gen.feature.TreeCluster;
import lotr.common.world.gen.feature.grassblend.GrassBlends;
import lotr.common.world.map.RoadBlockProvider;
import net.minecraft.block.Block;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class DorwinionBiome
extends LOTRBiomeBase {
    public DorwinionBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.1f).func_205420_b(0.3f).func_205414_c(0.8f).func_205417_d(0.9f), major);
    }

    protected DorwinionBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
        this.biomeColors.setGrass(10538541);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.addSubSoilLayer(((Block)LOTRBlocks.DIRTY_CHALK.get()).func_176223_P(), 1);
        config.addSubSoilLayer(((Block)LOTRBlocks.CHALK.get()).func_176223_P(), 5, 7);
    }

    @Override
    protected void addBoulders(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addBoulders(builder, ((Block)LOTRBlocks.CHALK.get()).func_176223_P(), 1, 2, 50, 3);
    }

    protected final Object[] dorwinionTrees() {
        return new Object[]{LOTRBiomeFeatures.oak(), 2000, LOTRBiomeFeatures.oakFancy(), 1000, LOTRBiomeFeatures.oakBees(), 200, LOTRBiomeFeatures.oakFancyBees(), 100, LOTRBiomeFeatures.birch(), 1000, LOTRBiomeFeatures.birchFancy(), 500, LOTRBiomeFeatures.birchBees(), 10, LOTRBiomeFeatures.birchFancyBees(), 5, LOTRBiomeFeatures.beech(), 200, LOTRBiomeFeatures.beechFancy(), 200, LOTRBiomeFeatures.beechBees(), 2, LOTRBiomeFeatures.beechFancyBees(), 2, LOTRBiomeFeatures.cypress(), 5000, LOTRBiomeFeatures.oakShrub(), 8000, LOTRBiomeFeatures.apple(), 50, LOTRBiomeFeatures.pear(), 50, LOTRBiomeFeatures.appleBees(), 1, LOTRBiomeFeatures.pearBees(), 1};
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addTreesWithClusters(this, builder, 0, 0.1f, TreeCluster.of(8, 15), this.dorwinionTrees());
        LOTRBiomeFeatures.addGrass(this, builder, 9, GrassBlends.EXTRA_WHEATGRASS);
        LOTRBiomeFeatures.addDoubleGrass(builder, 2, GrassBlends.DOUBLE_WITH_EXTRA_WHEATGRASS);
        LOTRBiomeFeatures.addRhunPlainsFlowers(builder, 6, new Object[0]);
        LOTRBiomeFeatures.addDefaultDoubleFlowers(builder, 1, new Object[0]);
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
        super.addAnimals(builder);
        this.addHorsesDonkeys(builder);
        this.addBears(builder);
    }

    @Override
    protected void addStructures(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addCraftingMonument(builder, ((Block)LOTRBlocks.DORWINION_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.DORWINION_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.RED_DORWINION_BRICK_WALL.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.BRONZE_LANTERN.get()).func_176223_P(), 1));
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.DORWINION_PATH;
    }

    public static class Hills
    extends DorwinionBiome {
        public Hills(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(0.8f).func_205420_b(0.8f).func_205414_c(0.8f).func_205417_d(0.9f), major);
        }

        @Override
        public double getHorizontalNoiseScale() {
            return 50.0;
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            config.setFillerDepth(0.0);
            config.addSubSoilLayer(((Block)LOTRBlocks.DIRTY_CHALK.get()).func_176223_P(), 1);
            config.addSubSoilLayer(((Block)LOTRBlocks.CHALK.get()).func_176223_P(), 5);
        }

        @Override
        protected void addVegetation(BiomeGenerationSettings.Builder builder) {
            LOTRBiomeFeatures.addTrees(this, builder, 0, 0.25f, this.dorwinionTrees());
            LOTRBiomeFeatures.addGrass(this, builder, 10, GrassBlends.STANDARD);
            LOTRBiomeFeatures.addDoubleGrass(builder, 5, GrassBlends.DOUBLE_STANDARD);
            LOTRBiomeFeatures.addRhunPlainsFlowers(builder, 3, new Object[0]);
            LOTRBiomeFeatures.addDefaultDoubleFlowers(builder, 1, new Object[0]);
        }

        @Override
        protected void addAnimals(MobSpawnInfo.Builder builder) {
            super.addAnimals(builder);
        }

        @Override
        protected void addStructures(BiomeGenerationSettings.Builder builder) {
        }

        @Override
        public RoadBlockProvider getRoadBlockProvider() {
            return RoadBlockProvider.CHALK_PATH;
        }
    }
}

