/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.util.LOTRUtil;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.gen.feature.TreeCluster;
import lotr.common.world.gen.feature.grassblend.GrassBlends;
import lotr.common.world.map.RoadBlockProvider;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.Property;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class EriadorBiome
extends LOTRBiomeBase {
    public EriadorBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.1f).func_205420_b(0.4f).func_205414_c(0.8f).func_205417_d(0.8f), major);
    }

    protected EriadorBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
    }

    @Override
    protected void addStoneVariants(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addCommonGranite(builder);
    }

    protected final Object[] eriadorTrees() {
        return new Object[]{LOTRBiomeFeatures.oak(), 10000, LOTRBiomeFeatures.oakFancy(), 1000, LOTRBiomeFeatures.oakBees(), 10, LOTRBiomeFeatures.oakFancyBees(), 1, LOTRBiomeFeatures.birch(), 1000, LOTRBiomeFeatures.birchFancy(), 100, LOTRBiomeFeatures.birchBees(), 1, LOTRBiomeFeatures.birchFancyBees(), 1, LOTRBiomeFeatures.spruce(), 2000, LOTRBiomeFeatures.beech(), 200, LOTRBiomeFeatures.beechFancy(), 20, LOTRBiomeFeatures.beechBees(), 1, LOTRBiomeFeatures.beechFancyBees(), 1, LOTRBiomeFeatures.maple(), 50, LOTRBiomeFeatures.mapleFancy(), 5, LOTRBiomeFeatures.mapleBees(), 1, LOTRBiomeFeatures.mapleFancyBees(), 1, LOTRBiomeFeatures.aspen(), 500, LOTRBiomeFeatures.aspenLarge(), 50, LOTRBiomeFeatures.apple(), 20, LOTRBiomeFeatures.pear(), 20, LOTRBiomeFeatures.appleBees(), 1, LOTRBiomeFeatures.pearBees(), 1};
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addTreesWithClusters(this, builder, 0, 0.08f, TreeCluster.of(8, 12), this.eriadorTrees());
        LOTRBiomeFeatures.addGrass(this, builder, 9, GrassBlends.STANDARD);
        LOTRBiomeFeatures.addDoubleGrass(builder, 4, GrassBlends.DOUBLE_STANDARD);
        LOTRBiomeFeatures.addPlainsFlowers(builder, 2, LOTRBlocks.LAVENDER.get(), 20);
        LOTRBiomeFeatures.addAthelasChance(builder);
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
        super.addAnimals(builder);
        this.addHorsesDonkeys(builder);
        this.addBears(builder, 2);
    }

    @Override
    protected void addStructures(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addCraftingMonument(builder, 2, ((Block)LOTRBlocks.RANGER_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.ARNOR_BRICK.get()).func_176223_P(), 4).func_227407_a_(((Block)LOTRBlocks.MOSSY_ARNOR_BRICK.get()).func_176223_P(), 1).func_227407_a_(((Block)LOTRBlocks.CRACKED_ARNOR_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(Blocks.field_180407_aO.func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(Blocks.field_150478_aa.func_176223_P(), 1));
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.ARNOR.withRepair(0.9f);
    }

    public static class ErynVorn
    extends EriadorBiome {
        public ErynVorn(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(0.1f).func_205420_b(0.4f).func_205414_c(0.8f).func_205417_d(0.9f), major);
        }

        @Override
        protected void addVegetation(BiomeGenerationSettings.Builder builder) {
            Object[] weightedTrees = LOTRUtil.combineVarargs(this.eriadorTrees(), LOTRBiomeFeatures.pine(), 10000, LOTRBiomeFeatures.pineDead(), 100, LOTRBiomeFeatures.fir(), 3000, LOTRBiomeFeatures.spruce(), 1000);
            LOTRBiomeFeatures.addTrees(this, builder, 10, 0.0f, weightedTrees);
            LOTRBiomeFeatures.addGrass(this, builder, 9, GrassBlends.WITH_FERNS);
            LOTRBiomeFeatures.addDoubleGrass(builder, 2, GrassBlends.DOUBLE_WITH_FERNS);
            LOTRBiomeFeatures.addForestFlowers(builder, 4, new Object[0]);
            LOTRBiomeFeatures.addDefaultDoubleFlowers(builder, 1, new Object[0]);
            LOTRBiomeFeatures.addAthelasChance(builder);
            LOTRBiomeFeatures.addFoxBerryBushes(builder);
        }

        @Override
        protected void addAnimals(MobSpawnInfo.Builder builder) {
            super.addAnimals(builder);
            this.addWolves(builder);
            this.addBears(builder);
            this.addFoxes(builder);
        }
    }

    public static class Minhiriath
    extends EriadorBiome {
        public Minhiriath(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.1f).func_205420_b(0.3f).func_205414_c(0.7f).func_205417_d(0.5f), major);
        }

        @Override
        protected void addBoulders(BiomeGenerationSettings.Builder builder) {
            super.addBoulders(builder);
            LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 1, 3, 32, 3);
        }

        @Override
        protected void addVegetation(BiomeGenerationSettings.Builder builder) {
            Object[] weightedTrees = LOTRUtil.combineVarargs(this.eriadorTrees(), LOTRBiomeFeatures.oakDead(), 20000, LOTRBiomeFeatures.spruceDead(), 6000, LOTRBiomeFeatures.beechDead(), 2000, LOTRBiomeFeatures.birchDead(), 1000);
            LOTRBiomeFeatures.addTreesWithClusters(this, builder, 0, 0.06f, TreeCluster.of(8, 30), weightedTrees);
            LOTRBiomeFeatures.addGrass(this, builder, 5, GrassBlends.STANDARD);
            LOTRBiomeFeatures.addDoubleGrass(builder, 3, GrassBlends.DOUBLE_STANDARD);
            LOTRBiomeFeatures.addPlainsFlowers(builder, 2, LOTRBlocks.LAVENDER.get(), 20);
            LOTRBiomeFeatures.addAthelasChance(builder);
        }

        @Override
        protected void addAnimals(MobSpawnInfo.Builder builder) {
            super.addAnimals(builder);
        }
    }

    public static class EvendimHills
    extends EriadorBiome {
        public EvendimHills(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(0.6f).func_205420_b(1.2f).func_205414_c(0.7f).func_205417_d(0.8f), major);
        }

        @Override
        protected void addVegetation(BiomeGenerationSettings.Builder builder) {
            Object[] lowTrees = new Object[]{LOTRBiomeFeatures.pine(), 1200, LOTRBiomeFeatures.pineDead(), 20, LOTRBiomeFeatures.spruce(), 300, LOTRBiomeFeatures.spruceThin(), 100, LOTRBiomeFeatures.spruceDead(), 100, LOTRBiomeFeatures.aspen(), 100, LOTRBiomeFeatures.aspenLarge(), 20, LOTRBiomeFeatures.oak(), 100, LOTRBiomeFeatures.oakFancy(), 20, LOTRBiomeFeatures.oakBees(), 1, LOTRBiomeFeatures.oakFancyBees(), 1, LOTRBiomeFeatures.birch(), 50, LOTRBiomeFeatures.birchFancy(), 10, LOTRBiomeFeatures.birchBees(), 1, LOTRBiomeFeatures.birchFancyBees(), 1};
            Object[] highTrees = new Object[]{LOTRBiomeFeatures.pine(), 300, LOTRBiomeFeatures.pineDead(), 600, LOTRBiomeFeatures.spruceThin(), 100, LOTRBiomeFeatures.spruceDead(), 200};
            LOTRBiomeFeatures.addTrees(this, builder, 0, 0.03f, highTrees);
            LOTRBiomeFeatures.addTreesBelowTreeline(this, builder, 10, 0.25f, 82, lowTrees);
            LOTRBiomeFeatures.addGrass(this, builder, 10, GrassBlends.MOORS);
            LOTRBiomeFeatures.addDoubleGrass(builder, 2, GrassBlends.DOUBLE_MOORS);
            LOTRBiomeFeatures.addForestFlowers(builder, 2, new Object[0]);
            LOTRBiomeFeatures.addAthelasChance(builder);
            LOTRBiomeFeatures.addTundraBushesFreq(builder, 2, (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_((BlockState)((Block)LOTRBlocks.PINE_LEAVES.get()).func_176223_P().func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true)), 1), 32);
        }

        @Override
        protected void addStructures(BiomeGenerationSettings.Builder builder) {
        }
    }

    public static class Downs
    extends EriadorBiome {
        public Downs(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.7f).func_205420_b(0.6f).func_205414_c(0.6f).func_205417_d(0.7f), major);
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            super.setupSurface(config);
            config.setFillerDepth(0.0);
            config.addSubSoilLayer(((Block)LOTRBlocks.DIRTY_CHALK.get()).func_176223_P(), 1);
            config.addSubSoilLayer(((Block)LOTRBlocks.CHALK.get()).func_176223_P(), 3);
        }

        @Override
        protected void addStoneVariants(BiomeGenerationSettings.Builder builder) {
            super.addStoneVariants(builder);
            LOTRBiomeFeatures.addDiorite(builder);
        }

        @Override
        protected void addBoulders(BiomeGenerationSettings.Builder builder) {
            super.addBoulders(builder);
            LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 1, 4, 40, 3);
            LOTRBiomeFeatures.addBoulders(builder, ((Block)LOTRBlocks.CHALK.get()).func_176223_P(), 1, 1, 16, 3);
            LOTRBiomeFeatures.addBoulders(builder, ((Block)LOTRBlocks.CHALK.get()).func_176223_P(), 2, 3, 40, 1);
        }

        @Override
        protected void addVegetation(BiomeGenerationSettings.Builder builder) {
            LOTRBiomeFeatures.addTrees(this, builder, 0, 0.03f, this.eriadorTrees());
            LOTRBiomeFeatures.addGrass(this, builder, 5, GrassBlends.MOORS);
            LOTRBiomeFeatures.addDoubleGrass(builder, 1, GrassBlends.DOUBLE_MOORS);
            LOTRBiomeFeatures.addPlainsFlowers(builder, 2, new Object[0]);
            LOTRBiomeFeatures.addAthelasChance(builder);
        }

        @Override
        public RoadBlockProvider getRoadBlockProvider() {
            return RoadBlockProvider.CHALK_PATH;
        }
    }
}

