/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.BaseGondorBiome;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.gen.feature.grassblend.GrassBlends;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;

public class EthirAnduinBiome
extends BaseGondorBiome {
    public EthirAnduinBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.SWAMP).func_205421_a(-0.22f).func_205420_b(0.0f).func_205414_c(0.9f).func_205417_d(1.0f), major);
    }

    @Override
    public float getStrengthOfAddedDepthNoise() {
        return 0.15f;
    }

    @Override
    public float getBiomeScaleSignificanceForChunkGen() {
        return 0.96f;
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        super.setupSurface(config);
        config.setMarsh(true);
    }

    @Override
    protected void addBiomeSandSediments(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addQuagmire(builder, 1);
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oak(), 100, LOTRBiomeFeatures.oakFancy(), 100, LOTRBiomeFeatures.oakSwamp(), 300, LOTRBiomeFeatures.birch(), 600, LOTRBiomeFeatures.cypress(), 1200, LOTRBiomeFeatures.oakShrub(), 3000};
        LOTRBiomeFeatures.addTreesBelowTreeline(this, builder, 4, 0.5f, 63, weightedTrees);
        LOTRBiomeFeatures.addTreesAboveTreeline(this, builder, 3, 0.5f, 64, weightedTrees);
        LOTRBiomeFeatures.addGrass(this, builder, 10, GrassBlends.MUTED_WITH_FERNS);
        LOTRBiomeFeatures.addDoubleGrass(builder, 8, GrassBlends.DOUBLE_MUTED_WITH_FERNS);
        LOTRBiomeFeatures.addSwampFlowers(builder, 4, LOTRBlocks.MALLOS.get(), 4);
        LOTRBiomeFeatures.addMoreMushroomsFreq(builder, 3);
        LOTRBiomeFeatures.addSwampSeagrass(builder);
        LOTRBiomeFeatures.addFallenLogs(builder, 1);
        LOTRBiomeFeatures.addAthelasChance(builder);
    }

    @Override
    protected void addReeds(BiomeGenerationSettings.Builder builder) {
        super.addReeds(builder);
        LOTRBiomeFeatures.addMoreSwampReeds(builder);
        LOTRBiomeFeatures.addSwampRushes(builder);
        LOTRBiomeFeatures.addSugarCane(builder);
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
    }

    @Override
    protected void addStructures(BiomeGenerationSettings.Builder builder) {
    }

    @Override
    public Biome getRiver(IWorld world) {
        return null;
    }
}

