/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.util.LOTRUtil;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.gen.feature.TreeCluster;
import lotr.common.world.gen.feature.grassblend.GrassBlends;
import lotr.common.world.map.RoadBlockProvider;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;

public class IthilienBiome
extends LOTRBiomeBase {
    public IthilienBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(0.15f).func_205420_b(0.5f).func_205414_c(0.9f).func_205417_d(0.9f), major);
    }

    protected IthilienBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.addSubSoilLayer(((Block)LOTRBlocks.GONDOR_ROCK.get()).func_176223_P(), 8, 10);
    }

    @Override
    protected void addStoneVariants(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addGranite(builder);
        LOTRBiomeFeatures.addDeepDiorite(builder);
        LOTRBiomeFeatures.addGondorRockPatches(builder);
    }

    @Override
    protected void addBoulders(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 1, 3, 40, 3);
    }

    protected Object[] getIthilienTrees() {
        return new Object[]{LOTRBiomeFeatures.oak(), 4000, LOTRBiomeFeatures.oakTall(), 1000, LOTRBiomeFeatures.oakFancy(), 1000, LOTRBiomeFeatures.oakBees(), 50, LOTRBiomeFeatures.oakTallBees(), 10, LOTRBiomeFeatures.oakFancyBees(), 20, LOTRBiomeFeatures.oakParty(), 50, LOTRBiomeFeatures.lebethron(), 1000, LOTRBiomeFeatures.lebethronFancy(), 500, LOTRBiomeFeatures.lebethronBees(), 10, LOTRBiomeFeatures.lebethronFancy(), 5, LOTRBiomeFeatures.lebethronParty(), 20, LOTRBiomeFeatures.birch(), 1500, LOTRBiomeFeatures.birchFancy(), 500, LOTRBiomeFeatures.birchBees(), 15, LOTRBiomeFeatures.birchFancyBees(), 5, LOTRBiomeFeatures.cedar(), 1500, LOTRBiomeFeatures.cypress(), 1800, LOTRBiomeFeatures.pine(), 500, LOTRBiomeFeatures.apple(), 50, LOTRBiomeFeatures.pear(), 50, LOTRBiomeFeatures.appleBees(), 5, LOTRBiomeFeatures.pearBees(), 5, LOTRBiomeFeatures.culumalda(), 40, LOTRBiomeFeatures.culumaldaBees(), 1};
    }

    protected float getIthilienTreesIncreaseChance() {
        return 0.7f;
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addTreesWithClusters(this, builder, 0, this.getIthilienTreesIncreaseChance(), TreeCluster.of(50, 2), this.getIthilienTrees());
        LOTRBiomeFeatures.addGrass(this, builder, 10, GrassBlends.WITH_FERNS);
        LOTRBiomeFeatures.addDoubleGrass(builder, 4, GrassBlends.DOUBLE_WITH_FERNS);
        this.addIthilienFlowers(builder);
        LOTRBiomeFeatures.addDefaultDoubleFlowers(builder, 3, new Object[0]);
        LOTRBiomeFeatures.addSunflowers(builder, 16);
        LOTRBiomeFeatures.addWaterLiliesWithFlowers(builder, 2);
        LOTRBiomeFeatures.addAthelasChance(builder);
        LOTRBiomeFeatures.addWildPipeweedChance(builder, 24);
        LOTRBiomeFeatures.addFoxBerryBushes(builder);
    }

    protected void addIthilienFlowers(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addForestFlowers(builder, 4, Blocks.field_196609_bf, 5, LOTRBlocks.ASPHODEL.get(), 10);
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
        super.addAnimals(builder);
        this.addHorsesDonkeys(builder);
        this.addDeer(builder);
        this.addBears(builder);
        this.addFoxes(builder);
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.GONDOR.withRepair(0.7f);
    }

    public static class Cormallen
    extends IthilienBiome {
        public Cormallen(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(0.12f).func_205420_b(0.2f).func_205414_c(0.9f).func_205417_d(0.9f), major);
            this.biomeColors.setFog(0xFFFFC7);
        }

        @Override
        protected Object[] getIthilienTrees() {
            return LOTRUtil.combineVarargs(super.getIthilienTrees(), LOTRBiomeFeatures.culumalda(), 12000, LOTRBiomeFeatures.culumaldaBees(), 240);
        }

        @Override
        protected float getIthilienTreesIncreaseChance() {
            return 0.5f;
        }

        @Override
        protected void addIthilienFlowers(BiomeGenerationSettings.Builder builder) {
            LOTRBiomeFeatures.addForestFlowers(builder, 4, Blocks.field_196609_bf, 5, LOTRBlocks.ASPHODEL.get(), 10, LOTRBlocks.MALLOS.get(), 20);
        }
    }
}

