/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import lotr.common.LOTRLog;
import lotr.common.LOTRMod;
import lotr.common.init.LOTRBiomes;
import lotr.common.init.LOTREntities;
import lotr.common.util.CalendarUtil;
import lotr.common.world.biome.ExtendedWeatherType;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.LOTRBiomeWrapper;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.gen.feature.WeightedRandomFeatureConfig;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.BiomeMaker;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public abstract class LOTRBiomeBase
implements LOTRBiomeWrapper {
    private ResourceLocation biomeName;
    private Biome actualBiome;
    private Biome.Builder unbuiltBiome;
    private BiomeAmbience.Builder unbuiltBiomeAmbience;
    private final boolean isMajorBiome;
    protected CustomBiomeColors biomeColors;
    protected static final int STANDARD_FOG_COLOR = 12638463;
    protected static final int STANDARD_WATER_FOG_COLOR = 329011;
    protected static final PerlinNoiseGenerator SNOW_VARIETY_NOISE = LOTRBiomeBase.makeSingleLayerPerlinNoise(2490309256000602L);
    private float treeDensityForPodzol;
    private int maxPodzolHeight = Integer.MAX_VALUE;
    private WeightedRandomFeatureConfig grassBonemealGenerator;

    protected LOTRBiomeBase(Biome.Builder builder, int waterFogColor, boolean major) {
        this.unbuiltBiome = builder;
        this.unbuiltBiomeAmbience = new BiomeAmbience.Builder().func_235246_b_(0xFFFFFF).func_235248_c_(waterFogColor);
        this.isMajorBiome = major;
        this.biomeColors = new CustomBiomeColors(builder);
    }

    protected LOTRBiomeBase(Biome.Builder builder, boolean major) {
        this(builder, 329011, major);
    }

    public LOTRBiomeBase setBiomeName(ResourceLocation name) {
        if (this.biomeName != null) {
            throw new IllegalStateException("Cannot set biomeName for LOTRBiome " + this.biomeName + " - already set!");
        }
        this.biomeName = name;
        return this;
    }

    public Biome initialiseActualBiome() {
        if (this.actualBiome != null) {
            throw new IllegalStateException("LOTRBiome object for " + this.biomeName + " is already initialised!");
        }
        this.setupBiomeAmbience(this.unbuiltBiomeAmbience);
        this.unbuiltBiome.func_235097_a_(this.unbuiltBiomeAmbience.func_235238_a_());
        this.unbuiltBiomeAmbience = null;
        BiomeGenerationSettings.Builder generationBuilder = new BiomeGenerationSettings.Builder();
        MiddleEarthSurfaceConfig surfaceBuilderConfig = MiddleEarthSurfaceConfig.createDefault();
        this.setupSurface(surfaceBuilderConfig);
        this.addFeatures(generationBuilder);
        surfaceBuilderConfig.setTreeDensityForPodzol(this.treeDensityForPodzol).setMaxPodzolHeight(this.maxPodzolHeight);
        generationBuilder.func_242517_a(LOTRBiomes.MIDDLE_EARTH_SURFACE.func_242929_a((ISurfaceBuilderConfig)surfaceBuilderConfig));
        this.unbuiltBiome.func_242457_a(generationBuilder.func_242508_a());
        MobSpawnInfo.Builder entitySpawnBuilder = new MobSpawnInfo.Builder();
        this.addAnimals(entitySpawnBuilder);
        this.unbuiltBiome.func_242458_a(entitySpawnBuilder.func_242577_b());
        this.actualBiome = this.unbuiltBiome.func_242455_a();
        this.unbuiltBiome = null;
        return this.actualBiome;
    }

    @Override
    public final ResourceLocation getBiomeRegistryName() {
        return this.biomeName;
    }

    @Override
    public final Biome getActualBiome() {
        if (this.actualBiome != null) {
            return this.actualBiome;
        }
        throw new IllegalStateException("Cannot fetch Biome object for LOTRBiome " + this.biomeName + " - has not yet been initialised!");
    }

    public final boolean isMajorBiome() {
        return this.isMajorBiome;
    }

    public static PerlinNoiseGenerator makeSingleLayerPerlinNoise(long seed) {
        return new PerlinNoiseGenerator(new SharedSeedRandom(seed), (List)ImmutableList.of((Object)0));
    }

    protected void setupBiomeAmbience(BiomeAmbience.Builder builder) {
        if (this.biomeColors.hasGrass()) {
            this.unbuiltBiomeAmbience.func_242541_f(this.biomeColors.getGrass());
        }
        if (this.biomeColors.hasFoliage()) {
            this.unbuiltBiomeAmbience.func_242540_e(this.biomeColors.getFoliage());
        }
        this.unbuiltBiomeAmbience.func_242539_d(this.biomeColors.getSky());
        this.unbuiltBiomeAmbience.func_235239_a_(this.biomeColors.getFog());
        if (this.hasCustomWaterColor()) {
            this.unbuiltBiomeAmbience.func_235246_b_(this.getCustomWaterColor());
        }
        builder.func_235243_a_(MoodSoundAmbience.field_235027_b_);
    }

    protected void setupSurface(MiddleEarthSurfaceConfig config) {
    }

    protected void addFeatures(BiomeGenerationSettings.Builder builder) {
        this.addCarvers(builder);
        this.addLakes(builder);
        this.addDirtGravel(builder);
        this.addStoneVariants(builder);
        this.addOres(builder);
        this.addDripstones(builder);
        this.addCobwebs(builder);
        this.addSedimentDisks(builder);
        this.addBoulders(builder);
        this.addVegetation(builder);
        LOTRBiomeFeatures.addMushrooms(builder);
        this.addReeds(builder);
        this.addPumpkins(builder);
        this.addLiquidSprings(builder);
        LOTRBiomeFeatures.addFreezeTopLayer(builder);
        this.addStructures(builder);
    }

    protected void addCarvers(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addCarvers(builder);
    }

    protected void addLakes(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addLakes(builder);
    }

    protected void addDirtGravel(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addDirtGravel(builder);
    }

    protected void addStoneVariants(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addGranite(builder);
    }

    protected void addOres(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addOres(builder);
    }

    protected void addDripstones(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addDripstones(builder);
    }

    protected void addCobwebs(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addCobwebs(builder);
    }

    protected void addSedimentDisks(BiomeGenerationSettings.Builder builder) {
        this.addBiomeSandSediments(builder);
        LOTRBiomeFeatures.addClayGravelSediments(builder);
    }

    protected void addBiomeSandSediments(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addSandSediments(builder);
    }

    protected void addBoulders(BiomeGenerationSettings.Builder builder) {
    }

    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
    }

    public void setGrassBonemealGenerator(WeightedRandomFeatureConfig config) {
        this.grassBonemealGenerator = config;
    }

    @Override
    public BlockState getGrassForBonemeal(Random rand, BlockPos pos) {
        if (this.grassBonemealGenerator != null) {
            ConfiguredFeature feature = this.grassBonemealGenerator.getRandomFeature(rand);
            if (feature.field_222738_b instanceof BlockClusterFeatureConfig) {
                return ((BlockClusterFeatureConfig)feature.field_222738_b).field_227289_a_.func_225574_a_(rand, pos);
            }
            LOTRLog.warn("DEVELOPMENT ERROR: Biome (%s) grass bonemeal generator contains a FeatureConfig of invalid type - should be BlockClusterFeatureConfig, but is %s", this.biomeName, feature.field_222738_b.getClass().getName());
        }
        return Blocks.field_150349_c.func_176223_P();
    }

    protected void addReeds(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addReeds(builder);
    }

    protected void addPumpkins(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addPumpkins(builder);
    }

    protected void addLiquidSprings(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addWaterLavaSprings(builder);
    }

    @Override
    public boolean isSurfaceBlockForNPCSpawn(BlockState state) {
        MiddleEarthSurfaceConfig sc = (MiddleEarthSurfaceConfig)this.getActualBiome().func_242440_e().func_242502_e();
        return sc.isSurfaceBlockForNPCSpawning(state);
    }

    @Override
    public List<MobSpawnInfo.Spawners> getSpawnsAtLocation(EntityClassification creatureType, BlockPos pos) {
        return this.actualBiome.func_242433_b().func_242559_a(creatureType);
    }

    protected void addAnimals(MobSpawnInfo.Builder builder) {
        this.addLandCreatures(builder);
        this.addAmbientCreatures(builder);
    }

    protected void addLandCreatures(MobSpawnInfo.Builder builder) {
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200737_ac, 24, 4, 4));
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200784_X, 20, 4, 4));
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200795_i, 20, 4, 4));
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200796_j, 16, 4, 4));
        this.addDeer(builder);
    }

    protected void addAmbientCreatures(MobSpawnInfo.Builder builder) {
        builder.func_242575_a(EntityClassification.AMBIENT, new MobSpawnInfo.Spawners(EntityType.field_200791_e, 10, 8, 8));
    }

    protected void addExtraSheep(MobSpawnInfo.Builder builder, int mul) {
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200737_ac, 24 * mul, 4, 4));
    }

    protected void addHorsesDonkeys(MobSpawnInfo.Builder builder) {
        this.addHorsesDonkeys(builder, 1);
    }

    protected void addHorsesDonkeys(MobSpawnInfo.Builder builder, int mul) {
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200762_B, 10 * mul, 2, 6));
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200798_l, 1 * mul, 1, 3));
    }

    protected void addWolves(MobSpawnInfo.Builder builder) {
        this.addWolves(builder, 1);
    }

    protected void addWolves(MobSpawnInfo.Builder builder, int mul) {
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200724_aC, 10 * mul, 4, 8));
    }

    protected void addFoxes(MobSpawnInfo.Builder builder) {
        this.addFoxes(builder, 1);
    }

    protected void addFoxes(MobSpawnInfo.Builder builder, int mul) {
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_220356_B, 16 * mul, 2, 4));
    }

    protected void addCaracals(MobSpawnInfo.Builder builder) {
        this.addCaracals(builder, 1);
    }

    protected void addCaracals(MobSpawnInfo.Builder builder, int mul) {
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)LOTREntities.CARACAL.get(), 12 * mul, 1, 4));
    }

    protected void addDeer(MobSpawnInfo.Builder builder) {
        this.addDeer(builder, 1);
    }

    protected void addDeer(MobSpawnInfo.Builder builder, int mul) {
    }

    protected void addBoars(MobSpawnInfo.Builder builder) {
        this.addBoars(builder, 1);
    }

    protected void addBoars(MobSpawnInfo.Builder builder, int mul) {
    }

    protected void addBears(MobSpawnInfo.Builder builder) {
        this.addBears(builder, 1);
    }

    protected void addBears(MobSpawnInfo.Builder builder, int mul) {
    }

    protected void addElk(MobSpawnInfo.Builder builder) {
        this.addElk(builder, 1);
    }

    protected void addElk(MobSpawnInfo.Builder builder, int mul) {
    }

    protected void addStructures(BiomeGenerationSettings.Builder builder) {
    }

    public final void updateBiomePodzolVariables(float treeDensity, int maxHeight) {
        this.treeDensityForPodzol = Math.max(this.treeDensityForPodzol, treeDensity);
        this.maxPodzolHeight = Math.min(this.maxPodzolHeight, maxHeight);
    }

    @Override
    public final Vector3d alterCloudColor(Vector3d clouds) {
        if (this.biomeColors.hasClouds()) {
            float[] colors = this.biomeColors.getCloudsRGB();
            clouds = clouds.func_216372_d((double)colors[0], (double)colors[1], (double)colors[2]);
        }
        return clouds;
    }

    @Override
    public final float getCloudCoverage() {
        return this.biomeColors.getCloudCoverage();
    }

    @Override
    public final boolean isFoggy() {
        return this.biomeColors.isFoggy();
    }

    @Override
    public final Biome.RainType getPrecipitationVisually() {
        if (LOTRBiomeBase.isChristmasSnowInVisualContext()) {
            return Biome.RainType.SNOW;
        }
        return this.actualBiome.func_201851_b();
    }

    private static boolean isChristmasSnowOverride() {
        return CalendarUtil.isChristmas();
    }

    private static boolean isChristmasSnowInVisualContext() {
        return LOTRBiomeBase.isChristmasSnowOverride() && LOTRMod.PROXY.isClient();
    }

    public static boolean isSnowingVisually(LOTRBiomeWrapper biomeWrapper, IWorld world, BlockPos pos) {
        float temp = biomeWrapper.getTemperatureForSnowWeatherRendering(world, pos);
        boolean isChristmas = LOTRBiomeBase.isChristmasSnowOverride();
        return isChristmas || LOTRBiomeBase.isTemperatureSuitableForSnow(temp);
    }

    public static boolean isTemperatureSuitableForSnow(float temp) {
        return temp < 0.15f;
    }

    @Override
    public float getTemperatureForSnowWeatherRendering(IWorld world, BlockPos pos) {
        return this.actualBiome.func_225486_c(pos);
    }

    @Override
    public final ExtendedWeatherType getExtendedWeatherVisually() {
        if (LOTRBiomeBase.isChristmasSnowInVisualContext()) {
            return ExtendedWeatherType.NONE;
        }
        return this.getBiomeExtendedWeather();
    }

    protected ExtendedWeatherType getBiomeExtendedWeather() {
        return ExtendedWeatherType.NONE;
    }

    public final boolean hasCustomWaterColor() {
        return this.biomeColors.hasWater();
    }

    public final int getCustomWaterColor() {
        return this.biomeColors.getWater();
    }

    @Override
    public void onGeographicalWaterColorUpdate(int waterColor, Biome biomeObjectInClientRegistry) {
        if (!this.hasCustomWaterColor()) {
            biomeObjectInClientRegistry.func_235089_q_().field_235206_c_ = waterColor;
        }
    }

    @Override
    public boolean isRiver() {
        return false;
    }

    @Override
    public Biome getRiver(IWorld world) {
        return this.getNormalRiver(world);
    }

    protected final Biome getNormalRiver(IWorld world) {
        return LOTRBiomes.getBiomeByRegistryName(LOTRBiomes.RIVER.getRegistryName(), world);
    }

    @Override
    public LOTRBiomeBase getShore() {
        if (this.actualBiome.func_185355_j() < 0.0f) {
            return this;
        }
        return LOTRBiomes.BEACH.getInitialisedBiomeWrapper();
    }

    public static class CustomBiomeColors {
        private int grass = -1;
        private int foliage = -1;
        private int sky;
        private final int defaultBiomeSky;
        private int clouds = -1;
        private float[] cloudsRGB = new float[3];
        private float cloudCoverage = 1.0f;
        private int fog;
        private float[] fogRGB = new float[3];
        private boolean foggy = false;
        private int water = -1;

        public CustomBiomeColors(Biome.Builder builder) {
            float biomeTemp = ((Float)ObfuscationReflectionHelper.getPrivateValue(Biome.Builder.class, (Object)builder, (String)"field_205427_f")).floatValue();
            this.defaultBiomeSky = BiomeMaker.func_244206_a((float)biomeTemp);
            this.setSky(this.defaultBiomeSky);
            this.setFog(12638463);
        }

        public boolean hasGrass() {
            return this.grass >= 0;
        }

        public int getGrass() {
            return this.grass;
        }

        public CustomBiomeColors setGrass(int i) {
            this.grass = i;
            return this;
        }

        public CustomBiomeColors resetGrass() {
            return this.setGrass(-1);
        }

        public boolean hasFoliage() {
            return this.foliage >= 0;
        }

        public int getFoliage() {
            return this.foliage;
        }

        public CustomBiomeColors setFoliage(int i) {
            this.foliage = i;
            return this;
        }

        public CustomBiomeColors resetFoliage() {
            return this.setFoliage(-1);
        }

        public int getSky() {
            return this.sky;
        }

        public CustomBiomeColors setSky(int i) {
            this.sky = i;
            return this;
        }

        public CustomBiomeColors resetSky() {
            return this.setSky(this.defaultBiomeSky);
        }

        public boolean hasClouds() {
            return this.clouds >= 0;
        }

        public int getClouds() {
            return this.clouds;
        }

        public float[] getCloudsRGB() {
            return this.cloudsRGB;
        }

        public CustomBiomeColors setClouds(int i) {
            this.clouds = i;
            this.cloudsRGB = new Color(this.clouds).getColorComponents(this.cloudsRGB);
            return this;
        }

        public float getCloudCoverage() {
            return this.cloudCoverage;
        }

        public CustomBiomeColors setCloudCoverage(float f) {
            this.cloudCoverage = f;
            return this;
        }

        public CustomBiomeColors resetClouds() {
            this.clouds = -1;
            this.cloudsRGB = null;
            this.cloudCoverage = 1.0f;
            return this;
        }

        public int getFog() {
            return this.fog;
        }

        public float[] getFogRGB() {
            return this.fogRGB;
        }

        public CustomBiomeColors setFog(int i) {
            this.fog = i;
            this.fogRGB = new Color(this.fog).getColorComponents(this.fogRGB);
            return this;
        }

        public boolean isFoggy() {
            return this.foggy;
        }

        public CustomBiomeColors setFoggy(boolean flag) {
            this.foggy = flag;
            return this;
        }

        public CustomBiomeColors resetFog() {
            this.setFog(12638463);
            this.fogRGB = null;
            this.foggy = false;
            return this;
        }

        public boolean hasWater() {
            return this.water >= 0;
        }

        public int getWater() {
            return this.water;
        }

        public CustomBiomeColors setWater(int i) {
            this.water = i;
            return this;
        }

        public CustomBiomeColors resetWater(int i) {
            return this.setWater(-1);
        }
    }
}

