/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.world.biome.ExtendedWeatherType;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.surface.SurfaceNoiseMixer;
import lotr.common.world.gen.feature.TreeCluster;
import lotr.common.world.gen.feature.grassblend.GrassBlends;
import lotr.common.world.map.RoadBlockProvider;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;

public class LostladenBiome
extends LOTRBiomeBase {
    public LostladenBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.DESERT).func_205421_a(0.2f).func_205420_b(0.1f).func_205414_c(0.9f).func_205417_d(0.2f), major);
        this.biomeColors.setSky(15592678);
        this.biomeColors.setCloudCoverage(0.7f);
        this.biomeColors.setFog(15393237);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setSurfaceNoiseMixer(SurfaceNoiseMixer.createNoiseMixer(SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(1).scales(0.4, 0.09).threshold(0.15).state(Blocks.field_196660_k).topOnly(), SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(2).scales(0.4, 0.09).threshold(0.05).states(Blocks.field_150354_m, 4, Blocks.field_150322_A, 1), SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(3).scales(0.4, 0.09).threshold(0.05).states(Blocks.field_150348_b, 4, Blocks.field_150351_n, 1)));
    }

    @Override
    protected void addOres(BiomeGenerationSettings.Builder builder) {
        super.addOres(builder);
        LOTRBiomeFeatures.addLapisOre(builder);
    }

    @Override
    protected void addBoulders(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 1, 3, 48, 3);
        LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150322_A.func_176223_P(), 1, 3, 48, 3);
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oakDead(), 200, LOTRBiomeFeatures.oakDesert(), 1000};
        LOTRBiomeFeatures.addTreesWithClusters(this, builder, 0, 0.02f, TreeCluster.of(8, 200), weightedTrees);
        LOTRBiomeFeatures.addGrass(this, builder, 3, GrassBlends.WITH_ARID);
        LOTRBiomeFeatures.addDoubleGrass(builder, 1, GrassBlends.DOUBLE_WITH_ARID);
        LOTRBiomeFeatures.addDefaultFlowers(builder, 0, new Object[0]);
        LOTRBiomeFeatures.addCactiAtSurfaceChance(builder, 200);
        LOTRBiomeFeatures.addDeadBushAtSurfaceChance(builder, 8);
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
    }

    @Override
    protected ExtendedWeatherType getBiomeExtendedWeather() {
        return ExtendedWeatherType.SANDSTORM;
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.HARAD.withRepair(0.3f);
    }
}

