/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.surface.MountainTerrainProvider;
import lotr.common.world.gen.feature.grassblend.GrassBlends;
import net.minecraft.block.Blocks;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;

public class MistyMountainsBiome
extends LOTRBiomeBase {
    public MistyMountainsBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(2.0f).func_205420_b(2.0f).func_205414_c(0.2f).func_205417_d(0.5f), major);
    }

    protected MistyMountainsBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
        this.biomeColors.setSky(12241873);
    }

    protected boolean isFoothills() {
        return false;
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        if (!this.isFoothills()) {
            config.setMountainTerrain(MountainTerrainProvider.createMountainTerrain(MountainTerrainProvider.MountainLayer.layerBuilder().above(120).state(Blocks.field_196604_cC).topOnly(), MountainTerrainProvider.MountainLayer.layerBuilder().above(90).useStone()));
        }
    }

    @Override
    protected void addStoneVariants(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addGranite(builder);
        LOTRBiomeFeatures.addDeepDiorite(builder);
    }

    @Override
    protected void addOres(BiomeGenerationSettings.Builder builder) {
        super.addOres(builder);
        LOTRBiomeFeatures.addMithrilOre(builder, 4);
        LOTRBiomeFeatures.addGlowstoneOre(builder);
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        Object[] treeParams = new Object[]{LOTRBiomeFeatures.spruce(), 400, LOTRBiomeFeatures.spruceThin(), 400, LOTRBiomeFeatures.spruceMega(), 100, LOTRBiomeFeatures.spruceThinMega(), 20, LOTRBiomeFeatures.spruceDead(), 50, LOTRBiomeFeatures.fir(), 500, LOTRBiomeFeatures.pine(), 500, LOTRBiomeFeatures.pineDead(), 50, LOTRBiomeFeatures.larch(), 300};
        LOTRBiomeFeatures.addTrees(this, builder, 0, 0.05f, treeParams);
        LOTRBiomeFeatures.addTreesBelowTreeline(this, builder, 2, 0.1f, 100, treeParams);
        LOTRBiomeFeatures.addGrass(this, builder, 3, GrassBlends.MUTED);
        LOTRBiomeFeatures.addDoubleGrass(builder, 1, GrassBlends.DOUBLE_MUTED);
        LOTRBiomeFeatures.addMountainsFlowers(builder, 1, LOTRBlocks.DWARFWORT.get(), 1);
    }

    @Override
    protected void addLiquidSprings(BiomeGenerationSettings.Builder builder) {
        if (!this.isFoothills()) {
            LOTRBiomeFeatures.addWaterLavaSpringsReducedAboveground(builder, 80, 0.15f);
        } else {
            super.addLiquidSprings(builder);
        }
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
    }

    @Override
    public Biome getRiver(IWorld world) {
        return this.isFoothills() ? super.getRiver(world) : null;
    }

    @Override
    public boolean hasMountainsMist() {
        return true;
    }

    public static class Foothills
    extends MistyMountainsBiome {
        public Foothills(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(0.7f).func_205420_b(0.9f).func_205414_c(0.25f).func_205417_d(0.6f), major);
        }

        @Override
        protected boolean isFoothills() {
            return true;
        }

        @Override
        public boolean hasMountainsMist() {
            return false;
        }
    }
}

