/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.BaseMordorBiome;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.surface.MountainTerrainProvider;
import lotr.common.world.biome.surface.SurfaceNoiseMixer;
import lotr.common.world.gen.feature.grassblend.GrassBlends;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.ParticleEffectAmbience;

public class MordorBiome
extends BaseMordorBiome {
    private static final int MORDOR_WATER_COLOR = 3884089;

    public MordorBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.DESERT).func_205421_a(0.3f).func_205420_b(0.5f).func_205414_c(1.5f).func_205417_d(0.0f), major);
    }

    protected MordorBiome(Biome.Builder builder, boolean major) {
        super(builder, 3884089, major);
        this.biomeColors.setGrass(7496538).setFoliage(5987138).setSky(0x605555).setClouds(6705223).setFog(6701621);
    }

    @Override
    protected void setupBiomeAmbience(BiomeAmbience.Builder builder) {
        super.setupBiomeAmbience(builder);
        builder.func_235244_a_(new ParticleEffectAmbience((IParticleData)ParticleTypes.field_239813_am_, 0.01f));
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        super.setupSurface(config);
        config.setSurfaceNoiseMixer(SurfaceNoiseMixer.createNoiseMixer(SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(1).scales(0.3, 0.06).threshold(0.1).state(LOTRBlocks.MORDOR_ROCK), SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(2).scales(0.3, 0.06).threshold(0.5).state(Blocks.field_196660_k), SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(3).scales(0.3, 0.06).threshold(0.2).state(LOTRBlocks.MORDOR_DIRT), SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(4).scales(0.3, 0.06).threshold(0.25).state(LOTRBlocks.MORDOR_GRAVEL)));
    }

    @Override
    protected void addFeatures(BiomeGenerationSettings.Builder builder) {
        super.addFeatures(builder);
        this.addBasalt(builder);
    }

    protected void addBasalt(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addMordorBasalt(builder, 16, 40);
    }

    @Override
    protected void addBoulders(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addBoulders(builder, ((Block)LOTRBlocks.MORDOR_ROCK.get()).func_176223_P(), 1, 3, 60, 3);
        LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 1, 2, 60, 3);
        LOTRBiomeFeatures.addBoulders(builder, ((Block)LOTRBlocks.MORDOR_ROCK.get()).func_176223_P(), 0, 1, 12, 3);
        LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 0, 1, 24, 3);
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addTreesBelowTreelineIncrease(this, builder, 0, 0.025f, 5, 100, LOTRBiomeFeatures.charred(), 100, LOTRBiomeFeatures.oakDead(), 50, LOTRBiomeFeatures.oakDesert(), 20);
        LOTRBiomeFeatures.addGrass(this, builder, 2, GrassBlends.MUTED_WITHOUT_THISTLES);
        LOTRBiomeFeatures.addMordorMoss(builder, 20);
        LOTRBiomeFeatures.addMordorGrass(builder, 4);
        LOTRBiomeFeatures.addMordorThorns(builder, 40);
        LOTRBiomeFeatures.addMorgulShrooms(builder, 32);
    }

    public static class Mountains
    extends MordorBiome {
        public Mountains(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(2.0f).func_205420_b(2.0f).func_205414_c(1.5f).func_205417_d(0.0f), major);
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            super.setupSurface(config);
            config.setRockyTerrain(false);
            config.setSurfaceNoiseMixer(SurfaceNoiseMixer.createNoiseMixer(SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(1).scales(0.3, 0.06).threshold(0.0).state(LOTRBlocks.MORDOR_ROCK), SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(2).scales(0.3, 0.06).threshold(0.65).state(Blocks.field_196660_k), SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(3).scales(0.3, 0.06).threshold(0.65).state(LOTRBlocks.MORDOR_DIRT), SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(4).scales(0.3, 0.06).threshold(0.1).state(LOTRBlocks.MORDOR_GRAVEL)));
            config.setMountainTerrain(MountainTerrainProvider.createMountainTerrain(MountainTerrainProvider.MountainLayer.layerBuilder().above(100).state(LOTRBlocks.MORDOR_ROCK)));
        }

        @Override
        protected void addBasalt(BiomeGenerationSettings.Builder builder) {
        }

        @Override
        public Biome getRiver(IWorld world) {
            return null;
        }
    }
}

