/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.surface.SurfaceNoiseMixer;
import lotr.common.world.gen.feature.TreeCluster;
import lotr.common.world.gen.feature.grassblend.GrassBlends;
import lotr.common.world.map.RoadBlockProvider;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class NurnBiome
extends LOTRBiomeBase {
    private static final int NURN_WATER_COLOR = 4413266;

    public NurnBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.1f).func_205420_b(0.2f).func_205414_c(0.8f).func_205417_d(0.5f), major);
    }

    protected NurnBiome(Biome.Builder builder, boolean major) {
        super(builder, 4413266, major);
        this.biomeColors.setGrass(10068025).setFoliage(7504951).setSky(10404589).setClouds(9342083).setWater(4413266);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setFillerDepth(2.0);
        config.addSubSoilLayer(((Block)LOTRBlocks.MORDOR_DIRT.get()).func_176223_P(), 3);
        config.addSubSoilLayer(((Block)LOTRBlocks.MORDOR_ROCK.get()).func_176223_P(), 1000);
        config.setSurfaceNoiseMixer(SurfaceNoiseMixer.createNoiseMixer(SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(2).scales(0.4, 0.08).threshold(0.4).state(Blocks.field_196660_k).topOnly()));
    }

    @Override
    protected void addDirtGravel(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addMordorDirtGravel(builder);
    }

    @Override
    protected void addStoneVariants(BiomeGenerationSettings.Builder builder) {
    }

    @Override
    protected void addOres(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addMordorOres(builder);
    }

    @Override
    protected void addBoulders(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addBoulders(builder, ((Block)LOTRBlocks.MORDOR_ROCK.get()).func_176223_P(), 1, 3, 40, 4);
        LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 1, 4, 60, 3);
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addTreesWithClusters(this, builder, 0, 0.25f, TreeCluster.of(6, 30), LOTRBiomeFeatures.oak(), 5000, LOTRBiomeFeatures.oakFancy(), 1000, LOTRBiomeFeatures.oakDesert(), 5000, LOTRBiomeFeatures.oakDead(), 2000, LOTRBiomeFeatures.cedar(), 1000, LOTRBiomeFeatures.charred(), 2000);
        LOTRBiomeFeatures.addGrass(this, builder, 8, GrassBlends.EXTRA_WHEATGRASS);
        LOTRBiomeFeatures.addDoubleGrass(builder, 3, GrassBlends.DOUBLE_WITH_EXTRA_WHEATGRASS);
        LOTRBiomeFeatures.addDefaultFlowers(builder, 1, new Object[0]);
        LOTRBiomeFeatures.addMordorGrass(builder, 2);
        LOTRBiomeFeatures.addMordorThorns(builder, 200);
    }

    @Override
    protected void addReeds(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addReedsWithDriedChance(builder, 0.6f);
    }

    @Override
    protected void addStructures(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addCraftingMonument(builder, ((Block)LOTRBlocks.MORDOR_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.MORDOR_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.MORDOR_BRICK_WALL.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.ORC_TORCH.get()).func_176223_P(), 1));
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.NURN_PATH;
    }

    public static class Marshes
    extends NurnBiome {
        public Marshes(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.SWAMP).func_205421_a(-0.22f).func_205420_b(0.0f).func_205414_c(0.7f).func_205417_d(0.8f), major);
            this.biomeColors.setGrass(8291139);
        }

        @Override
        public float getStrengthOfAddedDepthNoise() {
            return 0.15f;
        }

        @Override
        public float getBiomeScaleSignificanceForChunkGen() {
            return 0.96f;
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            super.setupSurface(config);
            config.setMarsh(true);
        }

        @Override
        protected void addBiomeSandSediments(BiomeGenerationSettings.Builder builder) {
            LOTRBiomeFeatures.addQuagmire(builder, 1);
        }

        @Override
        protected void addVegetation(BiomeGenerationSettings.Builder builder) {
            Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oak(), 500, LOTRBiomeFeatures.oakFancy(), 100, LOTRBiomeFeatures.oakSwamp(), 1000, LOTRBiomeFeatures.oakDead(), 1500, LOTRBiomeFeatures.oakShrub(), 6000};
            LOTRBiomeFeatures.addTreesBelowTreeline(this, builder, 2, 0.5f, 63, weightedTrees);
            LOTRBiomeFeatures.addTreesAboveTreeline(this, builder, 3, 0.5f, 64, weightedTrees);
            LOTRBiomeFeatures.addGrass(this, builder, 10, GrassBlends.MUTED_WITH_FERNS);
            LOTRBiomeFeatures.addDoubleGrass(builder, 10, GrassBlends.DOUBLE_MUTED_WITH_FERNS);
            LOTRBiomeFeatures.addSwampFlowers(builder, 2, new Object[0]);
            LOTRBiomeFeatures.addMoreMushroomsFreq(builder, 4);
            LOTRBiomeFeatures.addSwampSeagrass(builder);
            LOTRBiomeFeatures.addFallenLogs(builder, 2);
        }

        @Override
        protected void addReeds(BiomeGenerationSettings.Builder builder) {
            super.addReeds(builder);
            LOTRBiomeFeatures.addMoreSwampReeds(builder);
            LOTRBiomeFeatures.addSwampRushes(builder);
        }

        @Override
        protected void addAnimals(MobSpawnInfo.Builder builder) {
        }

        @Override
        protected void addStructures(BiomeGenerationSettings.Builder builder) {
        }

        @Override
        public Biome getRiver(IWorld world) {
            return null;
        }
    }

    public static class Sea
    extends NurnBiome {
        public Sea(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.OCEAN).func_205421_a(-1.0f).func_205420_b(0.3f).func_205414_c(0.8f).func_205417_d(0.5f), major);
        }

        @Override
        public Biome getRiver(IWorld world) {
            return null;
        }
    }
}

