/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import java.util.List;
import java.util.Random;
import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.LOTRGrassColorModifiers;
import lotr.common.world.biome.SeaClimateWaterSpawns;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.surface.SurfaceNoiseMixer;
import lotr.common.world.biome.surface.UnderwaterNoiseMixer;
import lotr.common.world.gen.feature.LatitudeBasedFeatureConfig;
import lotr.common.world.gen.feature.grassblend.GrassBlends;
import lotr.common.world.map.MapSettingsManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.PerlinNoiseGenerator;

public class SeaBiome
extends LOTRBiomeBase {
    private final PerlinNoiseGenerator iceNoiseGen = SeaBiome.makeSingleLayerPerlinNoise(5231241491057810726L);
    private SeaClimateWaterSpawns coldWaterSpawns = new SeaClimateWaterSpawns();
    private SeaClimateWaterSpawns normalWaterSpawns = new SeaClimateWaterSpawns();
    private SeaClimateWaterSpawns tropicalWaterSpawns = new SeaClimateWaterSpawns();
    private final Random waterSpawningRand = new Random();

    public SeaBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.OCEAN).func_205421_a(-1.5f).func_205420_b(0.1f).func_205414_c(0.7f).func_205417_d(0.9f), major);
    }

    protected SeaBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
    }

    @Override
    protected void setupBiomeAmbience(BiomeAmbience.Builder builder) {
        super.setupBiomeAmbience(builder);
        builder.func_242537_a(LOTRGrassColorModifiers.SEA);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setUnderwaterNoiseMixer(UnderwaterNoiseMixer.SEA_LATITUDE);
    }

    @Override
    protected void addFeatures(BiomeGenerationSettings.Builder builder) {
        super.addFeatures(builder);
        this.addIcebergs(builder);
    }

    protected void addIcebergs(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addIcebergs(builder);
        LOTRBiomeFeatures.addBlueIcePatches(builder);
    }

    @Override
    protected void addCarvers(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addSeaCarvers(builder);
    }

    @Override
    protected void addStoneVariants(BiomeGenerationSettings.Builder builder) {
    }

    @Override
    protected void addOres(BiomeGenerationSettings.Builder builder) {
        super.addOres(builder);
        LOTRBiomeFeatures.addExtraSalt(builder, 8, 4, 64);
        LOTRBiomeFeatures.addSaltInSand(builder, 8, 1, 56, 80);
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addTreesWithLatitudeConfig(this, builder, LatitudeBasedFeatureConfig.LatitudeConfiguration.ofInverted(LatitudeBasedFeatureConfig.LatitudeValuesType.ICE).min(0.75f), 1, 0.1f, LOTRBiomeFeatures.oak(), 10000, LOTRBiomeFeatures.oakFancy(), 1000, LOTRBiomeFeatures.birch(), 1000, LOTRBiomeFeatures.birchFancy(), 100, LOTRBiomeFeatures.beech(), 500, LOTRBiomeFeatures.beechFancy(), 50, LOTRBiomeFeatures.apple(), 30, LOTRBiomeFeatures.pear(), 30);
        LOTRBiomeFeatures.addTreesWithLatitudeConfig(this, builder, LatitudeBasedFeatureConfig.LatitudeConfiguration.of(LatitudeBasedFeatureConfig.LatitudeValuesType.ICE), 0, 0.25f, LOTRBiomeFeatures.spruce(), 600, LOTRBiomeFeatures.spruceThin(), 400, LOTRBiomeFeatures.spruceDead(), 2000, LOTRBiomeFeatures.fir(), 400);
        LOTRBiomeFeatures.addGrass(this, builder, 6, GrassBlends.STANDARD);
        LOTRBiomeFeatures.addDoubleGrass(builder, 1, GrassBlends.DOUBLE_STANDARD);
        LOTRBiomeFeatures.addDefaultFlowers(builder, 2, new Object[0]);
        LOTRBiomeFeatures.addSeagrass(builder, 48, 0.4f);
        LOTRBiomeFeatures.addExtraUnderwaterSeagrass(builder);
        LOTRBiomeFeatures.addKelp(builder);
        LOTRBiomeFeatures.addCoral(builder);
        LOTRBiomeFeatures.addSeaPickles(builder);
        LOTRBiomeFeatures.addSponges(builder);
    }

    @Override
    public List<MobSpawnInfo.Spawners> getSpawnsAtLocation(EntityClassification creatureType, BlockPos pos) {
        if (creatureType == EntityClassification.WATER_CREATURE || creatureType == EntityClassification.WATER_AMBIENT) {
            int z = pos.func_177952_p();
            double iceProgressF = MapSettingsManager.serverInstance().getCurrentLoadedMap().getWaterLatitudes().getIceCoverageForLatitude(z);
            double coralProgressF = MapSettingsManager.serverInstance().getCurrentLoadedMap().getWaterLatitudes().getCoralForLatitude(z);
            if (iceProgressF > 0.0 && (double)this.waterSpawningRand.nextFloat() < iceProgressF) {
                return this.coldWaterSpawns.getSpawns(creatureType);
            }
            if (coralProgressF > 0.0 && (double)this.waterSpawningRand.nextFloat() < coralProgressF) {
                return this.tropicalWaterSpawns.getSpawns(creatureType);
            }
            return this.normalWaterSpawns.getSpawns(creatureType);
        }
        return super.getSpawnsAtLocation(creatureType, pos);
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
        this.addAmbientCreatures(builder);
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200737_ac, 6, 4, 4));
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200786_Z, 2, 1, 2));
        this.coldWaterSpawns.add(new MobSpawnInfo.Spawners(EntityType.field_200749_ao, 3, 1, 4));
        this.coldWaterSpawns.add(new MobSpawnInfo.Spawners(EntityType.field_203780_j, 15, 3, 6));
        this.coldWaterSpawns.add(new MobSpawnInfo.Spawners(EntityType.field_203778_ae, 15, 1, 5));
        this.normalWaterSpawns.add(new MobSpawnInfo.Spawners(EntityType.field_200749_ao, 1, 1, 4));
        this.normalWaterSpawns.add(new MobSpawnInfo.Spawners(EntityType.field_203780_j, 10, 3, 6));
        this.normalWaterSpawns.add(new MobSpawnInfo.Spawners(EntityType.field_205137_n, 1, 1, 2));
        this.tropicalWaterSpawns.add(new MobSpawnInfo.Spawners(EntityType.field_200749_ao, 10, 4, 4));
        this.tropicalWaterSpawns.add(new MobSpawnInfo.Spawners(EntityType.field_203779_Z, 15, 1, 3));
        this.tropicalWaterSpawns.add(new MobSpawnInfo.Spawners(EntityType.field_204262_at, 25, 8, 8));
        this.tropicalWaterSpawns.add(new MobSpawnInfo.Spawners(EntityType.field_205137_n, 2, 1, 2));
    }

    @Override
    public Biome getRiver(IWorld world) {
        return null;
    }

    @Override
    public boolean doesWaterFreeze(boolean defaultDoesSnowGenerate, IWorldReader world, BlockPos pos, boolean mustBeAtEdge) {
        if (this.isSeaFrozen(world, pos) && pos.func_177956_o() >= 0 && pos.func_177956_o() < world.func_230315_m_().func_241513_m_() && world.func_226658_a_(LightType.BLOCK, pos) < 10) {
            BlockState state = world.func_180495_p(pos);
            FluidState fluid = world.func_204610_c(pos);
            if (fluid.func_206886_c() == Fluids.field_204546_a && state.func_177230_c() instanceof FlowingFluidBlock) {
                boolean surrounded;
                if (!mustBeAtEdge) {
                    return true;
                }
                boolean bl = surrounded = world.func_201671_F(pos.func_177976_e()) && world.func_201671_F(pos.func_177974_f()) && world.func_201671_F(pos.func_177978_c()) && world.func_201671_F(pos.func_177968_d());
                if (!surrounded) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean doesSnowGenerate(boolean defaultDoesSnowGenerate, IWorldReader world, BlockPos pos) {
        BlockState state;
        return this.isSeaFrozen(world, pos) && pos.func_177956_o() >= 0 && pos.func_177956_o() < world.func_230315_m_().func_241513_m_() && world.func_226658_a_(LightType.BLOCK, pos) < 10 && (state = world.func_180495_p(pos)).func_196958_f() && Blocks.field_150433_aE.func_176223_P().func_196955_c(world, pos);
    }

    public boolean isSeaFrozen(IWorldReader world, BlockPos pos) {
        double noise2;
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        float iceProgressF = SeaBiome.getIceLatitudeLevel(world, z);
        if (iceProgressF <= 0.0f) {
            return false;
        }
        if (iceProgressF >= 1.0f) {
            return true;
        }
        double noise1 = this.iceNoiseGen.func_215464_a((double)x * 0.1, (double)z * 0.1, false);
        double noiseAvg = (noise1 + (noise2 = this.iceNoiseGen.func_215464_a((double)x * 0.03, (double)z * 0.03, false))) / 2.0;
        double noiseNorm = (noiseAvg + 1.0) / 2.0;
        return noiseNorm < (double)iceProgressF;
    }

    public static float getIceLatitudeLevel(IWorldReader world, int z) {
        return MapSettingsManager.sidedInstance(world).getCurrentLoadedMap().getWaterLatitudes().getIceCoverageForLatitude(z);
    }

    public static float getAdjustedTemperatureForGrassAndFoliage(IWorldReader world, Biome biome, int z) {
        float iceF = SeaBiome.getIceLatitudeLevel(world, z);
        float adjustedTemp = MathHelper.func_219799_g((float)iceF, (float)biome.func_242445_k(), (float)0.0f);
        return MathHelper.func_76131_a((float)adjustedTemp, (float)0.0f, (float)1.0f);
    }

    @Override
    public float getTemperatureForSnowWeatherRendering(IWorld world, BlockPos pos) {
        if (SeaBiome.getIceLatitudeLevel((IWorldReader)world, pos.func_177952_p()) > 0.25f) {
            return 0.0f;
        }
        return super.getTemperatureForSnowWeatherRendering(world, pos);
    }

    public static class WhiteBeach
    extends Beach {
        public WhiteBeach(boolean major) {
            super(major);
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            config.setTop(((Block)LOTRBlocks.WHITE_SAND.get()).func_176223_P());
            config.setFiller(((Block)LOTRBlocks.WHITE_SAND.get()).func_176223_P());
            config.setUnderwater(((Block)LOTRBlocks.WHITE_SAND.get()).func_176223_P());
        }

        @Override
        protected void addBiomeSandSediments(BiomeGenerationSettings.Builder builder) {
            LOTRBiomeFeatures.addWhiteSandSediments(builder);
        }
    }

    public static class Beach
    extends SeaBiome {
        public Beach(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.BEACH).func_205421_a(-0.1f).func_205420_b(0.03f).func_205414_c(0.8f).func_205417_d(0.7f), major);
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            config.setTop(Blocks.field_150354_m.func_176223_P());
            config.setFiller(Blocks.field_150354_m.func_176223_P());
            config.setUnderwater(Blocks.field_150354_m.func_176223_P());
        }

        @Override
        protected void addIcebergs(BiomeGenerationSettings.Builder builder) {
        }

        @Override
        protected void addVegetation(BiomeGenerationSettings.Builder builder) {
            super.addVegetation(builder);
            LOTRBiomeFeatures.addDriftwood(builder, 12);
        }

        @Override
        protected void addAnimals(MobSpawnInfo.Builder builder) {
            super.addAnimals(builder);
            builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_203099_aq, 10, 2, 5));
        }

        @Override
        public Biome getRiver(IWorld world) {
            return this.getNormalRiver(world);
        }
    }

    public static class WesternIsles
    extends Island {
        public WesternIsles(boolean major) {
            super(major);
        }

        @Override
        protected void addIcebergs(BiomeGenerationSettings.Builder builder) {
        }

        @Override
        protected void addStoneVariants(BiomeGenerationSettings.Builder builder) {
            LOTRBiomeFeatures.addAndesite(builder);
        }
    }

    public static class Island
    extends SeaBiome {
        public Island(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.OCEAN).func_205421_a(0.0f).func_205420_b(0.3f).func_205414_c(0.7f).func_205417_d(0.9f), major);
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            super.setupSurface(config);
            config.setSurfaceNoiseMixer(SurfaceNoiseMixer.createNoiseMixer(SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(1).scales(0.4, 0.09).threshold(0.7).state(Blocks.field_150351_n).topOnly(), SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(2).scales(0.4, 0.09).threshold(0.3).state(Blocks.field_150348_b)));
        }

        @Override
        protected void addIcebergs(BiomeGenerationSettings.Builder builder) {
        }

        @Override
        protected void addBoulders(BiomeGenerationSettings.Builder builder) {
            LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 1, 1, 2, 3);
        }
    }
}

