/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.util.LOTRUtil;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.surface.SurfaceNoiseMixer;
import lotr.common.world.gen.feature.TreeCluster;
import lotr.common.world.gen.feature.grassblend.GrassBlends;
import lotr.common.world.map.RoadBlockProvider;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class SouthronCoastsBiome
extends LOTRBiomeBase {
    public SouthronCoastsBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.2f).func_205420_b(0.1f).func_205414_c(1.2f).func_205417_d(0.7f), major);
    }

    protected SouthronCoastsBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
        this.biomeColors.setGrass(11914805);
        this.biomeColors.setFog(16248281);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setSurfaceNoiseMixer(SurfaceNoiseMixer.createNoiseMixer(SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(1).scales(0.25, 0.07, 0.002).threshold(0.13).state(Blocks.field_196660_k).topOnly(), SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(2).scales(0.25, 0.07, 0.002).threshold(0.3).state(Blocks.field_150354_m), SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(3).scales(0.25, 0.07, 0.002).threshold(0.53).state(Blocks.field_196611_F)));
    }

    @Override
    protected void addOres(BiomeGenerationSettings.Builder builder) {
        super.addOres(builder);
        LOTRBiomeFeatures.addLapisOre(builder);
    }

    protected final Object[] southronCoastsTrees() {
        return new Object[]{LOTRBiomeFeatures.cedar(), 8000, LOTRBiomeFeatures.oakDesert(), 5000, LOTRBiomeFeatures.oakDesertBees(), 50, LOTRBiomeFeatures.cypress(), 4000};
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addTreesWithClusters(this, builder, 0, 0.2f, TreeCluster.of(8, 24), this.southronCoastsTrees());
        LOTRBiomeFeatures.addGrass(this, builder, 10, GrassBlends.STANDARD);
        LOTRBiomeFeatures.addDoubleGrass(builder, 2, GrassBlends.DOUBLE_STANDARD);
        LOTRBiomeFeatures.addDeadBushes(builder, 1);
        LOTRBiomeFeatures.addHaradFlowers(builder, 3, new Object[0]);
        LOTRBiomeFeatures.addHaradDoubleFlowers(builder, 1, new Object[0]);
        LOTRBiomeFeatures.addCactiFreq(builder, 1);
    }

    @Override
    protected void addReeds(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addLessCommonReeds(builder);
        LOTRBiomeFeatures.addPapyrus(builder);
        LOTRBiomeFeatures.addSugarCane(builder);
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
        super.addAnimals(builder);
        this.addHorsesDonkeys(builder, 3);
        this.addCaracals(builder, 3);
    }

    @Override
    protected void addStructures(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addCraftingMonument(builder, ((Block)LOTRBlocks.HARAD_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.HARAD_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.CEDAR_FENCE.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.BRONZE_LANTERN.get()).func_176223_P(), 1));
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.HARAD_PATH;
    }

    public static class Forest
    extends SouthronCoastsBiome {
        public Forest(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(0.2f).func_205420_b(0.4f).func_205414_c(1.0f).func_205417_d(1.0f), major);
        }

        @Override
        protected void addVegetation(BiomeGenerationSettings.Builder builder) {
            LOTRBiomeFeatures.addTrees(this, builder, 6, 0.5f, LOTRUtil.combineVarargs(this.southronCoastsTrees(), LOTRBiomeFeatures.cedar(), 6000, LOTRBiomeFeatures.cedarLarge(), 1500));
            LOTRBiomeFeatures.addGrass(this, builder, 8, GrassBlends.STANDARD);
            LOTRBiomeFeatures.addDoubleGrass(builder, 1, GrassBlends.DOUBLE_STANDARD);
            LOTRBiomeFeatures.addDeadBushes(builder, 1);
            LOTRBiomeFeatures.addHaradFlowers(builder, 4, new Object[0]);
            LOTRBiomeFeatures.addHaradDoubleFlowers(builder, 2, new Object[0]);
            LOTRBiomeFeatures.addCactiFreq(builder, 1);
        }

        @Override
        protected void addAnimals(MobSpawnInfo.Builder builder) {
            super.addAnimals(builder);
        }
    }
}

