/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.gen.feature.TreeCluster;
import lotr.common.world.gen.feature.grassblend.GrassBlends;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;

public class WilderlandBiome
extends LOTRBiomeBase {
    public WilderlandBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.2f).func_205420_b(0.4f).func_205414_c(0.9f).func_205417_d(0.4f), major);
    }

    protected WilderlandBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
    }

    @Override
    protected void addBoulders(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 1, 3, 24, 4);
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addTreesWithClusters(this, builder, 0, 0.05f, TreeCluster.of(8, 20), LOTRBiomeFeatures.oak(), 10000, LOTRBiomeFeatures.oakFancy(), 1000, LOTRBiomeFeatures.oakBees(), 10, LOTRBiomeFeatures.oakFancyBees(), 1, LOTRBiomeFeatures.oakDead(), 5000, LOTRBiomeFeatures.spruce(), 2000, LOTRBiomeFeatures.spruceDead(), 1000);
        LOTRBiomeFeatures.addGrass(this, builder, 14, GrassBlends.STANDARD);
        LOTRBiomeFeatures.addDoubleGrass(builder, 8, GrassBlends.DOUBLE_STANDARD);
        LOTRBiomeFeatures.addRhunPlainsFlowers(builder, 3, new Object[0]);
        LOTRBiomeFeatures.addDefaultDoubleFlowers(builder, 1, new Object[0]);
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
        super.addAnimals(builder);
        this.addHorsesDonkeys(builder, 2);
        this.addBears(builder);
    }

    public static class Northern
    extends WilderlandBiome {
        private static final float SNOWY_TEMP = 0.15f;

        public Northern(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.2f).func_205420_b(0.5f).func_205414_c(0.5f).func_205417_d(0.6f), major);
        }

        @Override
        protected void addVegetation(BiomeGenerationSettings.Builder builder) {
            LOTRBiomeFeatures.addTreesWithClusters(this, builder, 0, 0.05f, TreeCluster.of(8, 40), LOTRBiomeFeatures.oak(), 5000, LOTRBiomeFeatures.oakFancy(), 1000, LOTRBiomeFeatures.oakBees(), 50, LOTRBiomeFeatures.oakFancyBees(), 10, LOTRBiomeFeatures.oakDead(), 5000, LOTRBiomeFeatures.spruce(), 3000, LOTRBiomeFeatures.spruceDead(), 1000, LOTRBiomeFeatures.fir(), 2000, LOTRBiomeFeatures.pine(), 2000);
            LOTRBiomeFeatures.addGrass(this, builder, 7, GrassBlends.STANDARD);
            LOTRBiomeFeatures.addDoubleGrass(builder, 3, GrassBlends.DOUBLE_STANDARD);
            LOTRBiomeFeatures.addBorealFlowers(builder, 2, new Object[0]);
        }

        @Override
        public float getTemperatureRaw(float defaultTemperatureAtPos, BlockPos pos) {
            return defaultTemperatureAtPos - this.getLocalSnowiness(pos) * (this.getActualBiome().func_242445_k() - 0.15f);
        }

        private float getLocalSnowiness(BlockPos pos) {
            int x = pos.func_177958_n();
            int z = pos.func_177952_p();
            double d1 = SNOW_VARIETY_NOISE.func_215464_a((double)x * 0.002, (double)z * 0.002, false);
            double d2 = SNOW_VARIETY_NOISE.func_215464_a((double)x * 0.05, (double)z * 0.05, false);
            double d3 = SNOW_VARIETY_NOISE.func_215464_a((double)x * 0.3, (double)z * 0.3, false);
            float biased = (float)Math.max((d1 *= 0.6) + (d2 *= 0.2) + (d3 *= 0.2), 0.0) + 0.5f;
            return MathHelper.func_76131_a((float)biased, (float)0.0f, (float)1.0f);
        }
    }
}

