/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.gen.feature.TreeCluster;
import lotr.common.world.gen.feature.grassblend.GrassBlends;
import lotr.common.world.map.RoadBlockProvider;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class WoodlandRealmBiome
extends LOTRBiomeBase {
    public WoodlandRealmBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(0.2f).func_205420_b(0.3f).func_205414_c(0.7f).func_205417_d(0.9f), major);
    }

    @Override
    protected void addCobwebs(BiomeGenerationSettings.Builder builder) {
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addTreesWithClusters(this, builder, 2, 0.33f, TreeCluster.of(16, 10), LOTRBiomeFeatures.greenOak(), 5000, LOTRBiomeFeatures.greenOakBees(), 5, LOTRBiomeFeatures.greenOakParty(), 800, LOTRBiomeFeatures.redOak(), 400, LOTRBiomeFeatures.redOakBees(), 5, LOTRBiomeFeatures.redOakParty(), 100, LOTRBiomeFeatures.greenOakShrub(), 8000, LOTRBiomeFeatures.oak(), 500, LOTRBiomeFeatures.oakBees(), 1, LOTRBiomeFeatures.oakFancy(), 1000, LOTRBiomeFeatures.oakFancyBees(), 1, LOTRBiomeFeatures.spruce(), 1000, LOTRBiomeFeatures.beech(), 500, LOTRBiomeFeatures.beechBees(), 1, LOTRBiomeFeatures.beechFancy(), 1000, LOTRBiomeFeatures.beechFancyBees(), 1, LOTRBiomeFeatures.larch(), 500, LOTRBiomeFeatures.fir(), 1000, LOTRBiomeFeatures.pine(), 500, LOTRBiomeFeatures.aspen(), 500, LOTRBiomeFeatures.aspenLarge(), 100);
        LOTRBiomeFeatures.addGrass(this, builder, 5, GrassBlends.WITH_FERNS);
        LOTRBiomeFeatures.addDoubleGrass(builder, 1, GrassBlends.DOUBLE_WITH_FERNS);
        LOTRBiomeFeatures.addForestFlowers(builder, 3, new Object[0]);
        LOTRBiomeFeatures.addDefaultDoubleFlowers(builder, 1, new Object[0]);
        LOTRBiomeFeatures.addMoreMushroomsFreq(builder, 1);
        LOTRBiomeFeatures.addFallenLogs(builder, 1);
    }

    @Override
    protected void addLiquidSprings(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addWaterSprings(builder);
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
        super.addAnimals(builder);
        this.addElk(builder, 8);
        this.addDeer(builder, 2);
        this.addBears(builder, 1);
    }

    @Override
    protected void addStructures(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addCraftingMonument(builder, ((Block)LOTRBlocks.WOOD_ELVEN_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.GREEN_OAK_PLANKS.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.GREEN_OAK_FENCE.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(Blocks.field_150478_aa.func_176223_P(), 1));
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.WOOD_ELVEN;
    }
}

