/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome.surface;

import com.mojang.serialization.Codec;
import java.util.Iterator;
import java.util.Random;
import lotr.common.init.LOTRBiomes;
import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.map.MapSettings;
import lotr.common.world.map.MapSettingsManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.surfacebuilders.FrozenOceanSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class MiddleEarthSurfaceBuilder
extends SurfaceBuilder<MiddleEarthSurfaceConfig> {
    private final FrozenOceanSurfaceBuilder frozenOcean = new FrozenOceanSurfaceBuilder(SurfaceBuilderConfig.field_237203_a_);
    private final PerlinNoiseGenerator icebergBorderNoise = LOTRBiomeBase.makeSingleLayerPerlinNoise(5231241491057810726L);

    public MiddleEarthSurfaceBuilder(Codec<MiddleEarthSurfaceConfig> codec) {
        super(codec);
    }

    private boolean isFrozenIcebergTerrain(IChunk chunk, Biome biome, int x, int z) {
        if (LOTRBiomes.areBiomesEqual(biome, LOTRBiomes.SEA.getInitialisedBiome(), chunk.getWorldForge())) {
            MapSettings map = MapSettingsManager.serverInstance().getCurrentLoadedMap();
            int zBlurRange = 32;
            float icebergThreshold = 0.5f;
            int minAdjustedZ = z - zBlurRange;
            if (map.getWaterLatitudes().getIceCoverageForLatitude(minAdjustedZ) > icebergThreshold) {
                double xBlurScale = 1.0 / (double)zBlurRange;
                int adjustedZ = z + (int)(this.icebergBorderNoise.func_215464_a((double)x * xBlurScale, 0.0, false) * (double)zBlurRange);
                return map.getWaterLatitudes().getIceCoverageForLatitude(adjustedZ) > icebergThreshold;
            }
        }
        return false;
    }

    public void buildSurface(Random rand, IChunk chunk, Biome biome, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, MiddleEarthSurfaceConfig config) {
        int y;
        if (this.isFrozenIcebergTerrain(chunk, biome, x, z)) {
            this.frozenOcean.func_205610_a_(rand, chunk, biome, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, SurfaceBuilder.field_215425_v);
            return;
        }
        int chunkX = x & 0xF;
        int chunkZ = z & 0xF;
        BlockPos.Mutable movingPos = new BlockPos.Mutable();
        BlockState top = config.getSurfaceNoiseReplacement(x, z, config.func_204108_a(), true, rand);
        BlockState filler = config.getSurfaceNoiseReplacement(x, z, config.func_204109_b(), false, rand);
        BlockState underwater = config.getUnderwaterNoiseReplacement(x, z, config.getUnderwaterMaterial(), rand);
        int digDepth = -1;
        int soilDepth = (int)(noise * 0.25 + config.getFillerDepth() + rand.nextDouble() * 0.25);
        if (soilDepth < 0) {
            soilDepth = 0;
        }
        int determinedTopTerrainY = -1;
        if (config.hasRockyTerrain()) {
            int topBlock = startHeight - 1;
            movingPos.func_181079_c(chunkX, topBlock, chunkZ);
            if (topBlock >= 90 && chunk.func_180495_p((BlockPos)movingPos) == defaultBlock) {
                float hFactor = (float)(topBlock - 90) / 10.0f;
                float threshold = 0.6f - hFactor * 0.1f;
                threshold = Math.max(threshold, 0.0f);
                double[] dArray = new double[]{0.3, 0.03};
                double rockyNoise = MiddleEarthSurfaceConfig.getNoise1(x, z, dArray);
                if (rockyNoise > (double)threshold) {
                    top = rand.nextFloat() < 0.2f ? Blocks.field_150351_n.func_176223_P() : Blocks.field_150348_b.func_176223_P();
                    int prevTopBlock = topBlock++;
                    if (rand.nextInt(20) == 0) {
                        // empty if block
                    }
                    for (y = topBlock; y >= prevTopBlock; --y) {
                        movingPos.func_181079_c(chunkX, y, chunkZ);
                        chunk.func_177436_a((BlockPos)movingPos, top, false);
                    }
                }
            }
        }
        if (config.hasPodzol() && startHeight - 1 <= config.getMaxPodzolHeight() && !config.isMarsh()) {
            float trees;
            float podzolMinThreshold = 0.0f;
            boolean podzolHere = false;
            if (top.func_177230_c() == Blocks.field_196658_i && (trees = config.getTreeDensityForPodzol()) >= 1.5f) {
                float threshold = 0.8f;
                threshold -= trees * 0.15f;
                threshold = Math.max(threshold, podzolMinThreshold);
                double[] dArray = new double[]{0.05};
                double randNoise = MiddleEarthSurfaceConfig.getNoise2(x, z, dArray);
                if (randNoise > (double)threshold) {
                    podzolHere = true;
                }
            }
            if (podzolHere) {
                float pdzRand = rand.nextFloat();
                if (pdzRand < 0.45f) {
                    top = Blocks.field_196661_l.func_176223_P();
                } else if (pdzRand < 0.6f) {
                    top = Blocks.field_196660_k.func_176223_P();
                } else if (pdzRand < 0.605f) {
                    top = Blocks.field_150351_n.func_176223_P();
                }
            }
        }
        if (config.isMarsh()) {
            double marshNoiseScale1 = 0.25;
            double marshNoiseScale2 = 0.05;
            double marshNoise = (MiddleEarthSurfaceConfig.MARSH_NOISE.func_215464_a((double)x * marshNoiseScale1, (double)z * marshNoiseScale1, false) + MiddleEarthSurfaceConfig.MARSH_NOISE.func_215464_a((double)x * marshNoiseScale2, (double)z * marshNoiseScale2, false)) / 2.0;
            if (marshNoise > -0.1) {
                for (y = startHeight; y >= 0; --y) {
                    movingPos.func_181079_c(chunkX, y, chunkZ);
                    BlockState currentState = chunk.func_180495_p((BlockPos)movingPos);
                    if (currentState.func_196958_f()) continue;
                    if (y != seaLevel - 1 || currentState.func_185904_a().func_76224_d()) break;
                    chunk.func_177436_a((BlockPos)movingPos, Blocks.field_150355_j.func_176223_P(), false);
                    break;
                }
            }
        }
        BlockState topToUse = top;
        BlockState fillerToUse = filler;
        Iterator<MiddleEarthSurfaceConfig.SubSoilLayer> subSoilLayers = config.getSubSoilLayers();
        for (int y2 = startHeight; y2 >= 0; --y2) {
            movingPos.func_181079_c(chunkX, y2, chunkZ);
            BlockState currentState = chunk.func_180495_p((BlockPos)movingPos);
            if (currentState.func_196958_f()) {
                digDepth = -1;
                continue;
            }
            if (currentState.func_177230_c() != defaultBlock.func_177230_c()) continue;
            if (digDepth == -1) {
                if (soilDepth < 0) {
                    topToUse = Blocks.field_150350_a.func_176223_P();
                    fillerToUse = defaultBlock;
                } else if (y2 >= seaLevel - 4 && y2 <= seaLevel + 1) {
                    topToUse = top;
                    fillerToUse = filler;
                }
                if (y2 < seaLevel && (topToUse == null || topToUse.func_196958_f())) {
                    topToUse = biome.func_225486_c((BlockPos)movingPos.func_181079_c(x, y2, z)) < 0.15f ? Blocks.field_150432_aD.func_176223_P() : defaultFluid;
                    movingPos.func_181079_c(chunkX, y2, chunkZ);
                }
                digDepth = soilDepth;
                if (y2 >= seaLevel - 1) {
                    chunk.func_177436_a((BlockPos)movingPos, topToUse, false);
                } else if (y2 < seaLevel - 7 - soilDepth) {
                    topToUse = Blocks.field_150350_a.func_176223_P();
                    fillerToUse = defaultBlock;
                    chunk.func_177436_a((BlockPos)movingPos, underwater, false);
                } else {
                    chunk.func_177436_a((BlockPos)movingPos, fillerToUse, false);
                }
                if (determinedTopTerrainY != -1) continue;
                determinedTopTerrainY = y2;
                continue;
            }
            if (digDepth > 0) {
                --digDepth;
                chunk.func_177436_a((BlockPos)movingPos, fillerToUse, false);
                continue;
            }
            if (digDepth != 0) continue;
            if (subSoilLayers.hasNext()) {
                MiddleEarthSurfaceConfig.SubSoilLayer subSoilLayer = subSoilLayers.next();
                digDepth = subSoilLayer.getDepth(rand);
                fillerToUse = subSoilLayer.getMaterial();
            } else if (soilDepth > 1) {
                if (fillerToUse.func_177230_c() == Blocks.field_150354_m) {
                    digDepth = rand.nextInt(4) + Math.max(0, y2 - seaLevel);
                    fillerToUse = Blocks.field_150322_A.func_176223_P();
                } else if (fillerToUse.func_177230_c() == Blocks.field_196611_F) {
                    digDepth = rand.nextInt(4) + Math.max(0, y2 - seaLevel);
                    fillerToUse = Blocks.field_180395_cM.func_176223_P();
                } else if (fillerToUse.func_177230_c() == LOTRBlocks.WHITE_SAND.get()) {
                    digDepth = rand.nextInt(4) + Math.max(0, y2 - seaLevel);
                    fillerToUse = ((Block)LOTRBlocks.WHITE_SANDSTONE.get()).func_176223_P();
                }
            }
            if (digDepth <= 0) continue;
            --digDepth;
            chunk.func_177436_a((BlockPos)movingPos, fillerToUse, false);
        }
        if (config.hasMountainTerrain()) {
            int stoneNoiseDepth = (int)(noise * 6.0 + 2.0 + rand.nextDouble() * 1.0);
            boolean passedTopBlock = false;
            for (int y3 = determinedTopTerrainY; y3 >= 0; --y3) {
                movingPos.func_181079_c(chunkX, y3, chunkZ);
                BlockState currentState = chunk.func_180495_p((BlockPos)movingPos);
                if (!currentState.func_204520_s().func_206888_e()) break;
                if (currentState.func_196958_f()) continue;
                boolean isTop = !passedTopBlock;
                BlockState mountainBlock = config.getMountainTerrain(x, z, y3, currentState, defaultBlock, isTop, stoneNoiseDepth);
                if (mountainBlock != currentState) {
                    chunk.func_177436_a((BlockPos)movingPos, mountainBlock, false);
                }
                if (!isTop || passedTopBlock) continue;
                passedTopBlock = true;
            }
        }
    }

    public void func_205548_a(long seed) {
        this.frozenOcean.func_205548_a(seed);
    }
}

