/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome.surface;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraftforge.fml.RegistryObject;

public final class MountainTerrainProvider {
    public static final MountainTerrainProvider NONE = MountainTerrainProvider.createMountainTerrain(new MountainLayer[0]);
    public static final Codec<MountainTerrainProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MountainLayer.CODEC.listOf().fieldOf("layers").forGetter(mixer -> mixer.layers)).apply((Applicative)instance, MountainTerrainProvider::new));
    private final List<MountainLayer> layers;

    private MountainTerrainProvider(List<MountainLayer> layers) {
        this.layers = layers;
    }

    public static MountainTerrainProvider createMountainTerrain(MountainLayer ... layers) {
        return new MountainTerrainProvider(Arrays.asList(layers));
    }

    public static MountainTerrainProvider createMountainTerrain(MountainLayer.MountainLayerBuilder ... builders) {
        return new MountainTerrainProvider(Stream.of(builders).map(MountainLayer.MountainLayerBuilder::build).collect(Collectors.toList()));
    }

    public BlockState getReplacement(int x, int z, int y, BlockState in, BlockState stone, boolean top, int stoneNoiseDepth) {
        for (MountainLayer layer : this.layers) {
            if (!layer.passes(y, in, stone, top, stoneNoiseDepth)) continue;
            return layer.getState(stone);
        }
        return in;
    }

    public static final class MountainLayer {
        public static final Codec<MountainLayer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("above").forGetter(layer -> layer.above), (App)BlockState.field_235877_b_.optionalFieldOf("state").forGetter(layer -> layer.state), (App)Codec.BOOL.fieldOf("use_stone").orElse((Object)false).forGetter(cond -> cond.useStone), (App)Codec.BOOL.fieldOf("replace_stone").orElse((Object)true).forGetter(cond -> cond.replaceStone), (App)Codec.BOOL.fieldOf("top_only").orElse((Object)false).forGetter(cond -> cond.topOnly)).apply((Applicative)instance, MountainLayer::new));
        private final int above;
        private final Optional<BlockState> state;
        private final boolean useStone;
        private final boolean replaceStone;
        private final boolean topOnly;

        private MountainLayer(int above, Optional<BlockState> state, boolean useStone, boolean replaceStone, boolean topOnly) {
            this.above = above;
            this.state = state;
            this.useStone = useStone;
            this.replaceStone = replaceStone;
            this.topOnly = topOnly;
        }

        private MountainLayer(MountainLayerBuilder builder) {
            this(builder.above, Optional.ofNullable(builder.state), builder.useStone, builder.replaceStone, builder.topOnly);
        }

        public static MountainLayerBuilder layerBuilder() {
            return new MountainLayerBuilder();
        }

        public boolean passes(int y, BlockState in, BlockState stone, boolean top, int stoneNoiseDepth) {
            if (this.topOnly && !top) {
                return false;
            }
            if (!this.replaceStone && in.func_177230_c() == stone.func_177230_c()) {
                return false;
            }
            return y >= this.above - stoneNoiseDepth;
        }

        public BlockState getState(BlockState stone) {
            if (this.useStone) {
                return stone;
            }
            return this.state.get();
        }

        public static class MountainLayerBuilder {
            private int above = -1;
            private BlockState state;
            private boolean useStone = false;
            private boolean replaceStone = true;
            private boolean topOnly = false;

            private MountainLayerBuilder() {
            }

            public MountainLayerBuilder above(int above) {
                this.above = above;
                return this;
            }

            public MountainLayerBuilder state(BlockState state) {
                this.state = state;
                this.useStone = false;
                return this;
            }

            public MountainLayerBuilder state(Block block) {
                return this.state(block.func_176223_P());
            }

            public MountainLayerBuilder state(RegistryObject<Block> blockSup) {
                return this.state((Block)blockSup.get());
            }

            public MountainLayerBuilder useStone() {
                this.state = null;
                this.useStone = true;
                this.excludeStone();
                return this;
            }

            public MountainLayerBuilder excludeStone() {
                this.replaceStone = false;
                return this;
            }

            public MountainLayerBuilder topOnly() {
                this.topOnly = true;
                return this;
            }

            public MountainLayer build() {
                if (this.above < 0) {
                    throw new IllegalArgumentException("above y-value not set or too low");
                }
                if (this.state == null && !this.useStone) {
                    throw new IllegalArgumentException("block state not set and use_stone is not enabled instead");
                }
                return new MountainLayer(this);
            }
        }
    }
}

