/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome.surface;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.WeightedList;
import net.minecraftforge.fml.RegistryObject;

public final class SurfaceNoiseMixer {
    public static final SurfaceNoiseMixer NONE = SurfaceNoiseMixer.createNoiseMixer(new Condition[0]);
    public static final Codec<SurfaceNoiseMixer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Condition.CODEC.listOf().fieldOf("conditions").forGetter(mixer -> mixer.conditions)).apply((Applicative)instance, SurfaceNoiseMixer::new));
    private final List<Condition> conditions;
    private final Set<Block> cachedSurfaceBlocks;

    private SurfaceNoiseMixer(List<Condition> conditions) {
        this.conditions = conditions;
        this.cachedSurfaceBlocks = conditions.stream().flatMap(c -> ((Condition)c).weightedStates.func_220655_b().map(AbstractBlock.AbstractBlockState::func_177230_c)).distinct().collect(Collectors.toSet());
    }

    public static SurfaceNoiseMixer createNoiseMixer(Condition ... conditions) {
        return new SurfaceNoiseMixer(Arrays.asList(conditions));
    }

    public static SurfaceNoiseMixer createNoiseMixer(Condition.ConditionBuilder ... builders) {
        return new SurfaceNoiseMixer(Stream.of(builders).map(Condition.ConditionBuilder::build).collect(Collectors.toList()));
    }

    public BlockState getReplacement(int x, int z, BlockState in, boolean top, Random rand) {
        for (Condition condition : this.conditions) {
            if (!condition.passes(x, z, top)) continue;
            return condition.getState(rand);
        }
        return in;
    }

    public boolean isSurfaceBlock(BlockState state) {
        return this.cachedSurfaceBlocks.contains(state.func_177230_c());
    }

    public static final class Condition {
        public static final Codec<Condition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)1, (int)4).fieldOf("noise_index").forGetter(cond -> cond.noiseIndex), (App)Codec.DOUBLE.listOf().fieldOf("scales").forGetter(cond -> DoubleStream.of(cond.scales).boxed().collect(Collectors.toList())), (App)Codec.DOUBLE.listOf().fieldOf("x_scales").orElse((Object)ImmutableList.of()).forGetter(cond -> DoubleStream.of(cond.xScales).boxed().collect(Collectors.toList())), (App)Codec.DOUBLE.listOf().fieldOf("z_scales").orElse((Object)ImmutableList.of()).forGetter(cond -> DoubleStream.of(cond.zScales).boxed().collect(Collectors.toList())), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).listOf().fieldOf("weights").orElse((Object)ImmutableList.of()).forGetter(cond -> IntStream.of(cond.weights).boxed().collect(Collectors.toList())), (App)Codec.DOUBLE.fieldOf("threshold").forGetter(cond -> cond.threshold), (App)WeightedList.func_234002_a_((Codec)BlockState.field_235877_b_).fieldOf("states").forGetter(cond -> cond.weightedStates), (App)Codec.BOOL.fieldOf("top_only").orElse((Object)false).forGetter(cond -> cond.topOnly)).apply((Applicative)instance, Condition::new));
        private final int noiseIndex;
        private final double[] scales;
        private final double[] xScales;
        private final double[] zScales;
        private final int[] weights;
        private final double threshold;
        private final WeightedList<BlockState> weightedStates;
        private final boolean topOnly;

        private Condition(int noiseIndex, List<Double> scales, List<Double> xScales, List<Double> zScales, List<Integer> weights, double threshold, WeightedList<BlockState> weightedStates, boolean topOnly) {
            this(noiseIndex, Condition.toArray(scales), Condition.toArray(xScales), Condition.toArray(zScales), weights.stream().mapToInt(Integer::intValue).toArray(), threshold, weightedStates, topOnly);
        }

        private static double[] toArray(List<Double> list) {
            return list.stream().mapToDouble(Double::doubleValue).toArray();
        }

        private Condition(int noiseIndex, double[] scales, double[] xScales, double[] zScales, int[] weights, double threshold, WeightedList<BlockState> weightedStates, boolean topOnly) {
            this.noiseIndex = noiseIndex;
            this.scales = scales;
            this.xScales = xScales != null ? xScales : new double[]{};
            this.zScales = zScales != null ? zScales : new double[]{};
            this.weights = weights != null ? weights : new int[]{};
            this.threshold = threshold;
            this.weightedStates = weightedStates;
            this.topOnly = topOnly;
        }

        private Condition(ConditionBuilder builder) {
            this(builder.noiseIndex, builder.scales, builder.xScales, builder.zScales, builder.weights, builder.threshold, (WeightedList<BlockState>)builder.weightedStates, builder.topOnly);
        }

        public static ConditionBuilder conditionBuilder() {
            return new ConditionBuilder();
        }

        public boolean passes(int x, int z, boolean top) {
            if (this.topOnly && !top) {
                return false;
            }
            if (this.noiseIndex == 1) {
                return MiddleEarthSurfaceConfig.getNoise1(x, z, this.scales, this.xScales, this.zScales, this.weights) > this.threshold;
            }
            if (this.noiseIndex == 2) {
                return MiddleEarthSurfaceConfig.getNoise2(x, z, this.scales, this.xScales, this.zScales, this.weights) > this.threshold;
            }
            if (this.noiseIndex == 3) {
                return MiddleEarthSurfaceConfig.getNoise3(x, z, this.scales, this.xScales, this.zScales, this.weights) > this.threshold;
            }
            if (this.noiseIndex == 4) {
                return MiddleEarthSurfaceConfig.getNoise4(x, z, this.scales, this.xScales, this.zScales, this.weights) > this.threshold;
            }
            throw new IllegalStateException("Noise index " + this.noiseIndex + " does not correspond to a predefined noise generator");
        }

        public BlockState getState(Random rand) {
            return (BlockState)this.weightedStates.func_226318_b_(rand);
        }

        public static class ConditionBuilder {
            private int noiseIndex;
            private double[] scales;
            private double[] xScales;
            private double[] zScales;
            private double zScale = 1.0;
            private int[] weights;
            private double threshold = Double.NEGATIVE_INFINITY;
            private WeightedList<BlockState> weightedStates;
            private boolean topOnly = false;

            private ConditionBuilder() {
            }

            public ConditionBuilder noiseIndex(int noiseIndex) {
                this.noiseIndex = noiseIndex;
                return this;
            }

            public ConditionBuilder scales(double ... scales) {
                this.scales = scales;
                return this;
            }

            public ConditionBuilder xScales(double ... xScales) {
                this.xScales = xScales;
                return this;
            }

            public ConditionBuilder zScales(double ... zScales) {
                this.zScales = zScales;
                return this;
            }

            public ConditionBuilder weights(int ... weights) {
                this.weights = weights;
                return this;
            }

            public ConditionBuilder threshold(double threshold) {
                this.threshold = threshold;
                return this;
            }

            public ConditionBuilder state(BlockState state) {
                this.weightedStates = new WeightedList().func_226313_a_((Object)state, 1);
                return this;
            }

            public ConditionBuilder states(Object ... entries) {
                this.weightedStates = new WeightedList();
                for (int i = 0; i < entries.length; i += 2) {
                    BlockState state;
                    Object obj1 = entries[i];
                    if (obj1 instanceof BlockState) {
                        state = (BlockState)obj1;
                    } else if (obj1 instanceof Block) {
                        state = ((Block)obj1).func_176223_P();
                    } else if (obj1 instanceof RegistryObject) {
                        state = ((Block)((RegistryObject)obj1).get()).func_176223_P();
                    } else {
                        throw new IllegalArgumentException("Surface noise mixer cannot convert object " + obj1.toString() + " to a weighted blockstate");
                    }
                    int weight = (Integer)entries[i + 1];
                    this.weightedStates.func_226313_a_((Object)state, weight);
                }
                return this;
            }

            public ConditionBuilder state(Block block) {
                return this.state(block.func_176223_P());
            }

            public ConditionBuilder state(RegistryObject<Block> blockSup) {
                return this.state((Block)blockSup.get());
            }

            public ConditionBuilder topOnly() {
                this.topOnly = true;
                return this;
            }

            public Condition build() {
                if (this.noiseIndex < 1 || this.noiseIndex > 4) {
                    throw new IllegalArgumentException("noiseIndex out of supported range");
                }
                if (this.scales == null) {
                    throw new IllegalArgumentException("scales not set");
                }
                if (this.xScales != null && this.xScales.length != this.scales.length) {
                    throw new IllegalArgumentException("number of custom xScales does not match number of scales");
                }
                if (this.zScales != null && this.zScales.length != this.scales.length) {
                    throw new IllegalArgumentException("number of custom zScales does not match number of scales");
                }
                if (this.weights != null && this.weights.length != this.scales.length) {
                    throw new IllegalArgumentException("number of custom weights does not match number of scales");
                }
                if (this.threshold == Double.NEGATIVE_INFINITY) {
                    throw new IllegalArgumentException("threshold not set");
                }
                if (this.weightedStates == null || this.weightedStates.func_234005_b_()) {
                    throw new IllegalArgumentException("block state(s) not set");
                }
                return new Condition(this);
            }
        }
    }
}

