/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome.surface;

import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.Random;
import lotr.common.util.LOTRUtil;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.map.MapSettingsManager;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.IStringSerializable;

public enum UnderwaterNoiseMixer implements IStringSerializable
{
    NONE("none", (x, z, in, rand) -> in),
    SEA_LATITUDE("sea_latitude", (x, z, in, rand) -> {
        double noiseAvg;
        double noiseNorm;
        double sandProgressF = MapSettingsManager.serverInstance().getCurrentLoadedMap().getWaterLatitudes().getSandCoverageForLatitude(z);
        boolean sandy = false;
        sandy = sandProgressF <= 0.0 ? false : (sandProgressF >= 1.0 ? true : (noiseNorm = ((noiseAvg = MiddleEarthSurfaceConfig.getNoise1(x, z, 0.1, 0.03)) + 1.0) / 2.0) < sandProgressF);
        return sandy ? Blocks.field_150354_m.func_176223_P() : Blocks.field_150351_n.func_176223_P();
    });

    public static final Codec<UnderwaterNoiseMixer> CODEC;
    private static final Map<String, UnderwaterNoiseMixer> NAME_LOOKUP;
    private final String name;
    private final UnderwaterBlockReplacer underwaterBlockReplacer;

    private UnderwaterNoiseMixer(String s, UnderwaterBlockReplacer replacer) {
        this.name = s;
        this.underwaterBlockReplacer = replacer;
    }

    public String func_176610_l() {
        return this.name;
    }

    public static UnderwaterNoiseMixer forName(String name) {
        return NAME_LOOKUP.get(name);
    }

    public BlockState getReplacement(int x, int z, BlockState in, Random rand) {
        return this.underwaterBlockReplacer.getReplacement(x, z, in, rand);
    }

    static {
        CODEC = IStringSerializable.func_233023_a_(UnderwaterNoiseMixer::values, UnderwaterNoiseMixer::forName);
        NAME_LOOKUP = LOTRUtil.createKeyedEnumMap((Enum[])UnderwaterNoiseMixer.values(), UnderwaterNoiseMixer::func_176610_l);
    }

    @FunctionalInterface
    public static interface UnderwaterBlockReplacer {
        public BlockState getReplacement(int var1, int var2, BlockState var3, Random var4);
    }
}

