/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Function;
import lotr.common.LOTRLog;
import lotr.common.LOTRMod;
import lotr.common.init.LOTRBiomes;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.RegistryObject;

public class LOTRBiomeJsonGenerator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void generateBiomeJsons() {
        Path rootOutputPath = new File(LOTRMod.PROXY.getGameRootDirectory(), "lotrmod-data-output").toPath();
        Function jsonEncoder = JsonOps.INSTANCE.withEncoder((Encoder)Biome.field_242418_b);
        try {
            DirectoryCache cache = new DirectoryCache(rootOutputPath, "cache");
            for (RegistryObject regBiome : LOTRBiomes.BIOMES.getEntries()) {
                Biome biome = (Biome)regBiome.get();
                ResourceLocation biomeName = biome.getRegistryName();
                Path biomePath = LOTRBiomeJsonGenerator.getPath(rootOutputPath, biomeName);
                try {
                    Optional optJson = ((DataResult)jsonEncoder.apply(biome)).result();
                    if (optJson.isPresent()) {
                        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)((JsonElement)optJson.get()), (Path)biomePath);
                        continue;
                    }
                    LOTRLog.error("Couldn't generate biome JSON for %s - codec gave no result", biomeName);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LOTRLog.error("Error generating biome JSON for %s", biomeName);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            LOTRLog.error("Couldn't generate biome JSONs due to error");
        }
        LOTRLog.info("Generated up-to-date LOTR biome JSONs in %s upon request!", rootOutputPath);
    }

    private static Path getPath(Path rootPath, ResourceLocation biomeName) {
        return rootPath.resolve(biomeName.func_110624_b() + "/biomes/" + biomeName.func_110623_a() + ".json");
    }
}

