/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.carver;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.Set;
import lotr.common.init.LOTRBlocks;
import lotr.common.init.RegistryOrderHelper;
import lotr.common.world.gen.carver.MiddleEarthCanyonCarver;
import lotr.common.world.gen.carver.MiddleEarthCaveCarver;
import lotr.common.world.gen.carver.MiddleEarthUnderwaterCanyonCarver;
import lotr.common.world.gen.carver.MiddleEarthUnderwaterCaveCarver;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class LOTRWorldCarvers {
    public static final DeferredRegister<WorldCarver<?>> WORLD_CARVERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.WORLD_CARVERS, (String)"lotr");
    public static final WorldCarver<ProbabilityConfig> CAVE = LOTRWorldCarvers.preRegCarver("cave", new MiddleEarthCaveCarver((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_, 256));
    public static final WorldCarver<ProbabilityConfig> CANYON = LOTRWorldCarvers.preRegCarver("canyon", new MiddleEarthCanyonCarver((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_));
    public static final WorldCarver<ProbabilityConfig> UNDERWATER_CAVE = LOTRWorldCarvers.preRegCarver("underwater_cave", new MiddleEarthUnderwaterCaveCarver((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_));
    public static final WorldCarver<ProbabilityConfig> UNDERWATER_CANYON = LOTRWorldCarvers.preRegCarver("underwater_canyon", new MiddleEarthUnderwaterCanyonCarver((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_));

    public static void register() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        WORLD_CARVERS.register(bus);
    }

    private static <CC extends ICarverConfig, C extends WorldCarver<CC>> C preRegCarver(String name, C carver) {
        return (C)RegistryOrderHelper.preRegObject(WORLD_CARVERS, name, carver);
    }

    public static Set<Block> listCarvableBlocks() {
        return ImmutableSet.of((Object)Blocks.field_150348_b, (Object)Blocks.field_196650_c, (Object)Blocks.field_196654_e, (Object)Blocks.field_196656_g, (Object)LOTRBlocks.MORDOR_ROCK.get(), (Object)LOTRBlocks.GONDOR_ROCK.get(), (Object[])new Block[]{(Block)LOTRBlocks.ROHAN_ROCK.get(), (Block)LOTRBlocks.BLUE_ROCK.get(), (Block)LOTRBlocks.RED_ROCK.get(), (Block)LOTRBlocks.CHALK.get(), (Block)LOTRBlocks.DIRTY_CHALK.get(), (Block)LOTRBlocks.CHALK_PATH.get(), Blocks.field_150346_d, Blocks.field_196660_k, Blocks.field_196661_l, Blocks.field_196658_i, Blocks.field_185774_da, (Block)LOTRBlocks.MORDOR_DIRT.get(), (Block)LOTRBlocks.MORDOR_DIRT_PATH.get(), Blocks.field_150322_A, Blocks.field_180395_cM, (Block)LOTRBlocks.WHITE_SANDSTONE.get(), Blocks.field_150391_bh, Blocks.field_150433_aE, Blocks.field_196604_cC, Blocks.field_150403_cj, (Block)LOTRBlocks.SNOW_PATH.get()});
    }

    public static Set<Block> listLandOnlyCarvableBlocks() {
        return ImmutableSet.of((Object)Blocks.field_150354_m, (Object)Blocks.field_196611_F, (Object)LOTRBlocks.WHITE_SAND.get(), (Object)Blocks.field_150351_n, (Object)LOTRBlocks.MORDOR_GRAVEL.get());
    }

    public static Set<Block> listUnderwaterCarvableBlocks() {
        return new ImmutableSet.Builder().addAll(LOTRWorldCarvers.listCarvableBlocks()).addAll(LOTRWorldCarvers.listLandOnlyCarvableBlocks()).add(new Object[]{Blocks.field_150355_j, Blocks.field_150353_l, Blocks.field_150343_Z, Blocks.field_150350_a, Blocks.field_201941_jj}).build();
    }
}

