/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import lotr.common.world.gen.feature.CobwebFeatureConfig;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class CobwebFeature
extends Feature<CobwebFeatureConfig> {
    public CobwebFeature(Codec<CobwebFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, CobwebFeatureConfig config) {
        BlockPos.Mutable movingPos = new BlockPos.Mutable();
        BlockPos.Mutable adjPos = new BlockPos.Mutable();
        for (int l = 0; l < config.tries; ++l) {
            int x = pos.func_177958_n() - rand.nextInt(config.xspread) + rand.nextInt(config.xspread);
            int y = pos.func_177956_o() - rand.nextInt(config.yspread) + rand.nextInt(config.yspread);
            int z = pos.func_177952_p() - rand.nextInt(config.zspread) + rand.nextInt(config.zspread);
            movingPos.func_181079_c(x, y, z);
            if (!world.func_175623_d((BlockPos)movingPos)) continue;
            boolean anyStoneAdj = false;
            for (Direction dir : Direction.values()) {
                adjPos.func_189533_g((Vector3i)movingPos.func_177967_a(dir, 1));
                BlockState adjState = world.func_180495_p((BlockPos)adjPos);
                if (!adjState.func_200015_d((IBlockReader)world, (BlockPos)adjPos) || adjState.func_185904_a() != Material.field_151576_e) continue;
                anyStoneAdj = true;
                break;
            }
            if (!anyStoneAdj) continue;
            world.func_180501_a((BlockPos)movingPos, config.blockProvider.func_225574_a_(rand, (BlockPos)movingPos), 2);
        }
        return true;
    }
}

