/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import lotr.common.block.DoubleTorchBlock;
import lotr.common.world.gen.feature.CraftingMonumentFeatureConfig;
import lotr.common.world.gen.feature.LOTRFeatures;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class CraftingMonumentFeature
extends Feature<CraftingMonumentFeatureConfig> {
    public CraftingMonumentFeature(Codec<CraftingMonumentFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, CraftingMonumentFeatureConfig config) {
        if (LOTRFeatures.isSurfaceBlock((IWorld)world, pos.func_177977_b())) {
            int up = 2 + rand.nextInt(3);
            BlockPos tablePos = pos.func_177981_b(up);
            world.func_180501_a(tablePos, config.craftingTable, 2);
            BlockPos.Mutable movingPos = new BlockPos.Mutable();
            BlockPos.Mutable brickPos = new BlockPos.Mutable();
            int maxSteps = 8;
            int decoLayer = 2;
            for (int l = 1; l <= maxSteps; ++l) {
                boolean setAnyThisLayer = false;
                int y = -l;
                for (int x = -l; x <= l; ++x) {
                    for (int z = -l; z <= l; ++z) {
                        int maxY;
                        movingPos.func_189533_g((Vector3i)tablePos).func_196234_d(x, y, z);
                        int minY = maxY = movingPos.func_177956_o();
                        if (l == maxSteps) {
                            minY = 0;
                        }
                        brickPos.func_189533_g((Vector3i)movingPos);
                        for (int y1 = maxY; y1 >= minY; --y1) {
                            brickPos.func_185336_p(y1);
                            BlockState stateToReplace = world.func_180495_p((BlockPos)brickPos);
                            if (stateToReplace.func_200015_d((IBlockReader)world, (BlockPos)brickPos)) break;
                            BlockState newState = LOTRFeatures.getBlockStateInContext(config.baseBlockProvider.func_225574_a_(rand, (BlockPos)brickPos), (IWorld)world, (BlockPos)brickPos);
                            world.func_180501_a((BlockPos)brickPos, newState, 2);
                            LOTRFeatures.setGrassToDirtBelow((IWorld)world, (BlockPos)brickPos);
                            setAnyThisLayer = true;
                        }
                        if (l != decoLayer || Math.abs(x) != decoLayer || Math.abs(z) != decoLayer) continue;
                        BlockPos postPos = movingPos.func_177984_a();
                        BlockState post = config.postProvider.func_225574_a_(rand, postPos);
                        world.func_180501_a(postPos, post, 2);
                        world.func_180501_a(postPos.func_177984_a(), post, 2);
                        BlockPos torchPos = postPos.func_177981_b(2);
                        BlockState torch = config.torchProvider.func_225574_a_(rand, torchPos);
                        if (torch.func_177230_c() instanceof DoubleTorchBlock) {
                            ((DoubleTorchBlock)torch.func_177230_c()).placeTorchAt((IWorld)world, torchPos, 2);
                            continue;
                        }
                        world.func_180501_a(torchPos, torch, 2);
                    }
                }
                if (!setAnyThisLayer && l >= decoLayer) break;
            }
            return true;
        }
        return false;
    }
}

