/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import lotr.common.block.RottenLogBlock;
import lotr.common.init.LOTRBlocks;
import lotr.common.world.gen.feature.FallenLogFeatureConfig;
import lotr.common.world.gen.feature.LOTRFeatures;
import lotr.common.world.map.RoadPointCache;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class FallenLogFeature
extends Feature<FallenLogFeatureConfig> {
    public FallenLogFeature(Codec<FallenLogFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, FallenLogFeatureConfig config) {
        int length;
        Direction dir;
        if (!this.isSuitablePositionForLog((IWorld)world, pos)) {
            return false;
        }
        if (!RoadPointCache.checkNotGeneratingOnRoad(world, pos)) {
            return false;
        }
        if (!config.horizontalOnly && rand.nextInt(3) == 0) {
            dir = Direction.UP;
            length = MathHelper.func_76136_a((Random)rand, (int)1, (int)2);
        } else {
            dir = Direction.Plane.HORIZONTAL.func_179518_a(rand);
            length = MathHelper.func_76136_a((Random)rand, (int)2, (int)7);
        }
        Block logBlock = config.isStripped ? (Block)LOTRBlocks.STRIPPED_ROTTEN_LOG.get() : (Block)LOTRBlocks.ROTTEN_LOG.get();
        BlockState logAxisState = (BlockState)logBlock.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)dir.func_176740_k());
        BlockPos.Mutable movingPos = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        for (int i = 0; i < length && this.isSuitablePositionForLog((IWorld)world, (BlockPos)movingPos); ++i) {
            boolean waterlogged = world.func_204610_c((BlockPos)movingPos).func_206886_c() == Fluids.field_204546_a;
            BlockState placeState = (BlockState)logAxisState.func_206870_a((Property)RottenLogBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
            world.func_180501_a((BlockPos)movingPos, placeState, 2);
            if (dir.func_176740_k() != Direction.Axis.Y) {
                LOTRFeatures.setGrassToDirtBelow((IWorld)world, (BlockPos)movingPos);
            }
            movingPos.func_189536_c(dir);
        }
        return true;
    }

    private boolean isSuitablePositionForLog(IWorld world, BlockPos pos) {
        BlockPos belowPos = pos.func_177977_b();
        if (!world.func_180495_p(belowPos).func_224755_d((IBlockReader)world, belowPos, Direction.UP)) {
            return false;
        }
        BlockState replacingState = world.func_180495_p(pos);
        return replacingState.isAir((IBlockReader)world, pos) || replacingState.func_185904_a() == Material.field_151586_h;
    }
}

