/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import lotr.common.world.gen.feature.GrassPatchFeatureConfig;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class GrassPatchFeature
extends Feature<GrassPatchFeatureConfig> {
    public GrassPatchFeature(Codec<GrassPatchFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, GrassPatchFeatureConfig config) {
        BlockState below = world.func_180495_p(pos.func_177977_b());
        if (config.targetStates.contains(below)) {
            int r = MathHelper.func_76136_a((Random)rand, (int)config.minRadius, (int)config.maxRadius);
            int depth = MathHelper.func_76136_a((Random)rand, (int)config.minDepth, (int)config.maxDepth);
            BlockPos.Mutable movingPos = new BlockPos.Mutable();
            for (int x = -r; x <= r; ++x) {
                block1: for (int z = -r; z <= r; ++z) {
                    BlockPos heightPos;
                    movingPos.func_189533_g((Vector3i)pos).func_196234_d(x, 0, z);
                    if (x * x + z * z >= r * r || Math.abs((heightPos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, (BlockPos)movingPos)).func_177956_o() - pos.func_177956_o()) > 3) continue;
                    boolean coarse = rand.nextInt(5) == 0;
                    for (int y = 0; y < depth; ++y) {
                        movingPos.func_189533_g((Vector3i)heightPos).func_196234_d(0, -y - 1, 0);
                        BlockState state = world.func_180495_p((BlockPos)movingPos);
                        if (!config.targetStates.contains(state)) continue block1;
                        if (coarse) {
                            world.func_180501_a((BlockPos)movingPos, Blocks.field_196660_k.func_176223_P(), 3);
                            continue;
                        }
                        if (y == 0) {
                            world.func_180501_a((BlockPos)movingPos, Blocks.field_196658_i.func_176223_P(), 3);
                            continue;
                        }
                        world.func_180501_a((BlockPos)movingPos, Blocks.field_150346_d.func_176223_P(), 3);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

