/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class LeafBushesFeature
extends Feature<NoFeatureConfig> {
    public LeafBushesFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        BlockPos belowPos;
        BlockState below;
        BlockState leafBlockState = null;
        int searchTries = 40;
        int searchXRange = 6;
        int searchYRangeUp = 12;
        int searchZRange = 6;
        BlockPos.Mutable movingPos = new BlockPos.Mutable();
        for (int i = 0; i < searchTries; ++i) {
            int x = MathHelper.func_76136_a((Random)rand, (int)(-searchXRange), (int)searchXRange);
            int y = rand.nextInt(searchYRangeUp + 1);
            int z = MathHelper.func_76136_a((Random)rand, (int)(-searchZRange), (int)searchZRange);
            movingPos.func_189533_g((Vector3i)pos).func_196234_d(x, y, z);
            BlockState state = world.func_180495_p((BlockPos)movingPos);
            if (!state.func_235714_a_((ITag)BlockTags.field_206952_E)) continue;
            leafBlockState = state.func_177230_c().func_176223_P();
            if (!leafBlockState.func_235901_b_((Property)LeavesBlock.field_208495_b)) break;
            leafBlockState = (BlockState)leafBlockState.func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true));
            break;
        }
        if (leafBlockState != null && (below = world.func_180495_p(belowPos = pos.func_177977_b())).canSustainPlant((IBlockReader)world, belowPos, Direction.UP, (IPlantable)Blocks.field_196674_t)) {
            int size = 0;
            if (rand.nextInt(3) == 0) {
                ++size;
            }
            int y = 0;
            for (int x = -size; x <= size; ++x) {
                for (int z = -size; z <= size; ++z) {
                    if (size != 0 && Math.abs(x) == size && Math.abs(z) == size && rand.nextInt(3) != 0) continue;
                    movingPos.func_189533_g((Vector3i)pos).func_196234_d(x, y, z);
                    BlockState state = world.func_180495_p((BlockPos)movingPos);
                    if (state.func_185904_a().func_76224_d() || !state.func_185904_a().func_76222_j()) continue;
                    world.func_180501_a((BlockPos)movingPos, leafBlockState, 2);
                }
            }
            return true;
        }
        return false;
    }
}

