/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import lotr.common.world.gen.feature.MordorBasaltFeatureConfig;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class MordorBasaltFeature
extends Feature<MordorBasaltFeatureConfig> {
    public MordorBasaltFeature(Codec<MordorBasaltFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, MordorBasaltFeatureConfig config) {
        int radius = config.radius.func_242259_a(rand);
        float density = MathHelper.func_151240_a((Random)rand, (float)config.minDensity, (float)config.maxDensity);
        float prominence = MathHelper.func_151240_a((Random)rand, (float)config.minProminence, (float)config.maxProminence);
        boolean lava = rand.nextFloat() < config.lavaChance;
        int numTries = (int)((double)(radius * radius) * Math.PI * (double)density);
        BlockPos.Mutable movingPos = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        block0: for (int l = 0; l < numTries; ++l) {
            BlockPos abovePos;
            int moveX = rand.nextFloat() < density ? 1 : 2;
            int moveZ = rand.nextFloat() < density ? 1 : 2;
            movingPos.func_196234_d(MathHelper.func_76136_a((Random)rand, (int)(-moveX), (int)moveX), 0, MathHelper.func_76136_a((Random)rand, (int)(-moveZ), (int)moveZ));
            int dx = movingPos.func_177958_n() - pos.func_177958_n();
            int dz = movingPos.func_177952_p() - pos.func_177952_p();
            float rSq = (float)(dx * dx + dz * dz) / (float)(radius * radius);
            if (rSq > 1.0f) {
                movingPos.func_189533_g((Vector3i)pos);
            }
            int topY = world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, movingPos.func_177958_n(), movingPos.func_177952_p()) - 1;
            movingPos.func_185336_p(topY);
            boolean lavaHere = lava && rSq <= 0.25f && rand.nextInt(4) == 0 && this.canPlaceLavaHere((IWorld)world, (BlockPos)movingPos);
            int randDepth = config.depth.func_242259_a(rand);
            for (int d = 0; d < randDepth; ++d) {
                BlockState state = world.func_180495_p((BlockPos)movingPos);
                if (config.surfaceBlocks.contains(state.func_177230_c())) {
                    if (lavaHere && d == 0) {
                        this.func_230367_a_((IWorldWriter)world, (BlockPos)movingPos, Blocks.field_150353_l.func_176223_P());
                    } else {
                        this.func_230367_a_((IWorldWriter)world, (BlockPos)movingPos, Blocks.field_235337_cO_.func_176223_P());
                    }
                } else {
                    if (d != 0) break;
                    continue block0;
                }
                movingPos.func_189536_c(Direction.DOWN);
            }
            if (lavaHere || !(rand.nextFloat() < prominence) || !world.func_175623_d(abovePos = new BlockPos(movingPos.func_177958_n(), topY + 1, movingPos.func_177952_p()))) continue;
            this.func_230367_a_((IWorldWriter)world, abovePos, Blocks.field_235337_cO_.func_176223_P());
        }
        return true;
    }

    private boolean canPlaceLavaHere(IWorld world, BlockPos pos) {
        if (world.func_204610_c(pos.func_177984_a()).func_206888_e()) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                if (world.func_180495_p(pos.func_177972_a(dir)).func_200132_m()) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

