/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lotr.common.LOTRLog;
import lotr.common.world.gen.feature.WeightedFeature;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class WeightedRandomFeatureConfig<FC extends IFeatureConfig>
implements IFeatureConfig {
    public static final Codec<WeightedRandomFeatureConfig<IFeatureConfig>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)WeightedFeature.CODEC.listOf().fieldOf("weighted_features").forGetter(config -> ImmutableList.copyOf(config.weightedFeatures))).apply((Applicative)instance, WeightedRandomFeatureConfig::new));
    public final List<WeightedFeature<FC>> weightedFeatures;
    private int totalWeight;

    public WeightedRandomFeatureConfig(List<WeightedFeature<FC>> features) {
        this.weightedFeatures = features;
        this.updateTotalWeight();
    }

    public static <FC extends IFeatureConfig> WeightedRandomFeatureConfig<FC> fromEntries(Object ... entries) {
        try {
            ArrayList<WeightedFeature> tempList = new ArrayList<WeightedFeature>();
            for (int i = 0; i < entries.length; i += 2) {
                ConfiguredFeature feature = (ConfiguredFeature)entries[i];
                int weight = (Integer)entries[i + 1];
                WeightedFeature wf = WeightedFeature.make(feature, weight);
                tempList.add(wf);
            }
            return new WeightedRandomFeatureConfig<FC>(ImmutableList.copyOf(tempList));
        }
        catch (ArrayIndexOutOfBoundsException | ClassCastException e) {
            throw new IllegalArgumentException("Error adding biome trees! A list of (tree1, weight1), (tree2, weight2)... is required", e);
        }
    }

    private void updateTotalWeight() {
        this.totalWeight = 0;
        this.weightedFeatures.stream().forEach(wf -> this.totalWeight += wf.weight);
    }

    private int getTotalWeight() {
        return this.totalWeight;
    }

    public ConfiguredFeature<FC, ?> getRandomFeature(Random rand) {
        int totalWeight = this.getTotalWeight();
        int chosenWeight = rand.nextInt(totalWeight);
        WeightedFeature<FC> selected = null;
        for (WeightedFeature<FC> weightedFeature : this.weightedFeatures) {
            float featureWeight = weightedFeature.weight;
            if ((float)chosenWeight < featureWeight) {
                selected = weightedFeature;
                break;
            }
            chosenWeight = (int)((float)chosenWeight - featureWeight);
        }
        if (selected == null) {
            LOTRLog.error("WeightedRandomFeature error: total weight = %d, chosen weight = %d, but selected feature == null", totalWeight, chosenWeight);
        }
        return selected.feature;
    }
}

