/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature.grassblend;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import lotr.common.world.gen.feature.WeightedFeature;
import lotr.common.world.gen.feature.WeightedRandomFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;

public abstract class GrassBlend {
    private final List<Entry> entries;
    private WeightedRandomFeatureConfig<IFeatureConfig> bakedFeatureConfig;

    public GrassBlend(List<Entry> entries) {
        this.entries = entries;
    }

    protected static <T extends GrassBlend> T of(Function<List<Entry>, T> constructor, Object ... weightedConfigs) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (int i = 0; i < weightedConfigs.length; i += 2) {
            Supplier config = (Supplier)weightedConfigs[i];
            int weight = (Integer)weightedConfigs[i + 1];
            entries.add(new Entry(config, weight));
        }
        return (T)((GrassBlend)constructor.apply(entries));
    }

    private static WeightedRandomFeatureConfig<IFeatureConfig> toFeatureConfig(List<Entry> entries) {
        ArrayList weightedGrassTypes = new ArrayList();
        entries.forEach(entry -> weightedGrassTypes.add(WeightedFeature.make(Feature.field_227248_z_.func_225566_b_((IFeatureConfig)((Entry)entry).config.get()), ((Entry)entry).weight)));
        return new WeightedRandomFeatureConfig<IFeatureConfig>(weightedGrassTypes);
    }

    public WeightedRandomFeatureConfig<IFeatureConfig> getFeatureConfig() {
        if (this.bakedFeatureConfig == null) {
            this.bakedFeatureConfig = GrassBlend.toFeatureConfig(this.entries);
        }
        return this.bakedFeatureConfig;
    }

    public static class Entry {
        private final Supplier<BlockClusterFeatureConfig> config;
        private final int weight;

        public Entry(Supplier<BlockClusterFeatureConfig> config, int weight) {
            this.config = config;
            this.weight = weight;
        }
    }
}

