/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature.grassblend;

import java.util.function.Supplier;
import lotr.common.block.ThreeLeafCloverBlock;
import lotr.common.init.LOTRBlocks;
import lotr.common.world.gen.feature.grassblend.DoubleGrassBlend;
import lotr.common.world.gen.feature.grassblend.SingleGrassBlend;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.DoublePlantBlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;

public class GrassBlends {
    public static final Supplier<BlockClusterFeatureConfig> GRASS_CONFIG = () -> GrassBlends.buildSimpleGrassConfig(Blocks.field_150349_c, 32);
    public static final Supplier<BlockClusterFeatureConfig> FERN_CONFIG = () -> GrassBlends.buildSimpleGrassConfig(Blocks.field_196554_aH, 32);
    public static final Supplier<BlockClusterFeatureConfig> SHORT_GRASS_CONFIG = () -> GrassBlends.buildSimpleGrassConfig((Block)LOTRBlocks.SHORT_GRASS.get(), 32);
    public static final Supplier<BlockClusterFeatureConfig> WHEATGRASS_CONFIG = () -> GrassBlends.buildSimpleGrassConfig((Block)LOTRBlocks.WHEATGRASS.get(), 32);
    public static final Supplier<BlockClusterFeatureConfig> FLOWERY_GRASS_CONFIG = () -> GrassBlends.buildSimpleGrassConfig((Block)LOTRBlocks.FLOWERY_GRASS.get(), 32);
    public static final Supplier<BlockClusterFeatureConfig> PURPLE_MOOR_GRASS_CONFIG = () -> GrassBlends.buildSimpleGrassConfig((Block)LOTRBlocks.PURPLE_MOOR_GRASS.get(), 100);
    public static final Supplier<BlockClusterFeatureConfig> RED_MOOR_GRASS_CONFIG = () -> GrassBlends.buildSimpleGrassConfig((Block)LOTRBlocks.RED_MOOR_GRASS.get(), 100);
    public static final Supplier<BlockClusterFeatureConfig> THISTLE_CONFIG = () -> GrassBlends.buildSimpleGrassConfig((Block)LOTRBlocks.THISTLE.get(), 32);
    public static final Supplier<BlockClusterFeatureConfig> NETTLES_CONFIG = () -> GrassBlends.buildSimpleGrassConfig((Block)LOTRBlocks.NETTLES.get(), 32);
    public static final Supplier<BlockClusterFeatureConfig> FERNSPROUT_CONFIG = () -> GrassBlends.buildSimpleGrassConfig((Block)LOTRBlocks.FERNSPROUT.get(), 32);
    public static final Supplier<BlockClusterFeatureConfig> WILD_FLAX_CONFIG = () -> GrassBlends.buildSimpleGrassConfig((Block)LOTRBlocks.WILD_FLAX.get(), 32);
    public static final Supplier<BlockClusterFeatureConfig> ARID_GRASS_CONFIG = () -> GrassBlends.buildSimpleGrassConfig((Block)LOTRBlocks.ARID_GRASS.get(), 32);
    public static final Supplier<BlockClusterFeatureConfig> CLOVER_CONFIG = () -> {
        BlockState clover = ((Block)LOTRBlocks.CLOVER.get()).func_176223_P();
        BlockState clover2 = (BlockState)clover.func_206870_a((Property)ThreeLeafCloverBlock.NUM_CLOVERS, (Comparable)Integer.valueOf(2));
        BlockState clover3 = (BlockState)clover.func_206870_a((Property)ThreeLeafCloverBlock.NUM_CLOVERS, (Comparable)Integer.valueOf(3));
        BlockState clover4 = (BlockState)clover.func_206870_a((Property)ThreeLeafCloverBlock.NUM_CLOVERS, (Comparable)Integer.valueOf(4));
        BlockState fourLeafClover = ((Block)LOTRBlocks.FOUR_LEAF_CLOVER.get()).func_176223_P();
        return new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(clover, 1250).func_227407_a_(clover2, 1250).func_227407_a_(clover3, 1250).func_227407_a_(clover4, 1250).func_227407_a_(fourLeafClover, 1), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    };
    public static final Supplier<BlockClusterFeatureConfig> SHIRE_CLOVER_CONFIG = () -> {
        BlockState clover = ((Block)LOTRBlocks.CLOVER.get()).func_176223_P();
        BlockState clover2 = (BlockState)clover.func_206870_a((Property)ThreeLeafCloverBlock.NUM_CLOVERS, (Comparable)Integer.valueOf(2));
        BlockState clover3 = (BlockState)clover.func_206870_a((Property)ThreeLeafCloverBlock.NUM_CLOVERS, (Comparable)Integer.valueOf(3));
        BlockState clover4 = (BlockState)clover.func_206870_a((Property)ThreeLeafCloverBlock.NUM_CLOVERS, (Comparable)Integer.valueOf(4));
        BlockState fourLeafClover = ((Block)LOTRBlocks.FOUR_LEAF_CLOVER.get()).func_176223_P();
        return new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(clover, 1250).func_227407_a_(clover2, 1250).func_227407_a_(clover3, 1250).func_227407_a_(clover4, 1250).func_227407_a_(fourLeafClover, 10), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    };
    public static final Supplier<BlockClusterFeatureConfig> DOUBLE_GRASS_CONFIG = () -> GrassBlends.buildSimpleDoubleGrassConfig(Blocks.field_196804_gh, 64);
    public static final Supplier<BlockClusterFeatureConfig> DOUBLE_FERN_CONFIG = () -> GrassBlends.buildSimpleDoubleGrassConfig(Blocks.field_196805_gi, 64);
    public static final Supplier<BlockClusterFeatureConfig> DOUBLE_WHEATGRASS_CONFIG = () -> GrassBlends.buildSimpleDoubleGrassConfig((Block)LOTRBlocks.TALL_WHEATGRASS.get(), 64);
    public static final Supplier<BlockClusterFeatureConfig> DOUBLE_ARID_GRASS_CONFIG = () -> GrassBlends.buildSimpleDoubleGrassConfig((Block)LOTRBlocks.TALL_ARID_GRASS.get(), 64);
    public static final SingleGrassBlend STANDARD = SingleGrassBlend.of(GRASS_CONFIG, 500, SHORT_GRASS_CONFIG, 100, CLOVER_CONFIG, 250, WHEATGRASS_CONFIG, 100, FLOWERY_GRASS_CONFIG, 65, WILD_FLAX_CONFIG, 2, THISTLE_CONFIG, 5, NETTLES_CONFIG, 10);
    public static final SingleGrassBlend SHIRE = SingleGrassBlend.of(GRASS_CONFIG, 500, SHORT_GRASS_CONFIG, 100, SHIRE_CLOVER_CONFIG, 250, WHEATGRASS_CONFIG, 100, FLOWERY_GRASS_CONFIG, 65, WILD_FLAX_CONFIG, 2, THISTLE_CONFIG, 5, NETTLES_CONFIG, 10);
    public static final SingleGrassBlend WITH_FERNS = SingleGrassBlend.of(GRASS_CONFIG, 500, SHORT_GRASS_CONFIG, 100, CLOVER_CONFIG, 250, WHEATGRASS_CONFIG, 100, FLOWERY_GRASS_CONFIG, 65, WILD_FLAX_CONFIG, 2, THISTLE_CONFIG, 5, NETTLES_CONFIG, 10, FERN_CONFIG, 500);
    public static final SingleGrassBlend SHIRE_WITH_FERNS = SingleGrassBlend.of(GRASS_CONFIG, 500, SHORT_GRASS_CONFIG, 100, SHIRE_CLOVER_CONFIG, 250, WHEATGRASS_CONFIG, 100, FLOWERY_GRASS_CONFIG, 65, WILD_FLAX_CONFIG, 2, THISTLE_CONFIG, 5, NETTLES_CONFIG, 10, FERN_CONFIG, 500);
    public static final SingleGrassBlend WITH_FERNS_AND_SPROUTS = SingleGrassBlend.of(GRASS_CONFIG, 500, SHORT_GRASS_CONFIG, 100, CLOVER_CONFIG, 250, WHEATGRASS_CONFIG, 100, FLOWERY_GRASS_CONFIG, 65, WILD_FLAX_CONFIG, 2, THISTLE_CONFIG, 5, NETTLES_CONFIG, 10, FERN_CONFIG, 500, FERNSPROUT_CONFIG, 500);
    public static final SingleGrassBlend EXTRA_WHEATGRASS = SingleGrassBlend.of(GRASS_CONFIG, 500, SHORT_GRASS_CONFIG, 100, CLOVER_CONFIG, 250, WHEATGRASS_CONFIG, 800, FLOWERY_GRASS_CONFIG, 65, WILD_FLAX_CONFIG, 2, THISTLE_CONFIG, 5, NETTLES_CONFIG, 10);
    public static final SingleGrassBlend MOORS = SingleGrassBlend.of(GRASS_CONFIG, 500, SHORT_GRASS_CONFIG, 100, CLOVER_CONFIG, 250, THISTLE_CONFIG, 5, NETTLES_CONFIG, 10, PURPLE_MOOR_GRASS_CONFIG, 80, RED_MOOR_GRASS_CONFIG, 240);
    public static final SingleGrassBlend SHIRE_MOORS = SingleGrassBlend.of(GRASS_CONFIG, 500, SHORT_GRASS_CONFIG, 100, SHIRE_CLOVER_CONFIG, 250, THISTLE_CONFIG, 5, NETTLES_CONFIG, 10, PURPLE_MOOR_GRASS_CONFIG, 50, RED_MOOR_GRASS_CONFIG, 270);
    public static final SingleGrassBlend MOORS_WITH_FERNS = SingleGrassBlend.of(GRASS_CONFIG, 500, SHORT_GRASS_CONFIG, 100, CLOVER_CONFIG, 250, THISTLE_CONFIG, 5, NETTLES_CONFIG, 10, PURPLE_MOOR_GRASS_CONFIG, 50, RED_MOOR_GRASS_CONFIG, 270, FERN_CONFIG, 500);
    public static final SingleGrassBlend WITH_ARID = SingleGrassBlend.of(GRASS_CONFIG, 500, SHORT_GRASS_CONFIG, 100, CLOVER_CONFIG, 250, WHEATGRASS_CONFIG, 100, FLOWERY_GRASS_CONFIG, 65, WILD_FLAX_CONFIG, 2, THISTLE_CONFIG, 5, NETTLES_CONFIG, 10, ARID_GRASS_CONFIG, 550);
    public static final SingleGrassBlend BASIC = SingleGrassBlend.of(GRASS_CONFIG, 500, SHORT_GRASS_CONFIG, 100);
    public static final SingleGrassBlend MUTED = SingleGrassBlend.of(GRASS_CONFIG, 500, SHORT_GRASS_CONFIG, 100, CLOVER_CONFIG, 250, THISTLE_CONFIG, 5, NETTLES_CONFIG, 10);
    public static final SingleGrassBlend MUTED_WITHOUT_THISTLES = SingleGrassBlend.of(GRASS_CONFIG, 500, SHORT_GRASS_CONFIG, 100, CLOVER_CONFIG, 250, NETTLES_CONFIG, 10);
    public static final SingleGrassBlend MUTED_WITH_FERNS = SingleGrassBlend.of(GRASS_CONFIG, 500, SHORT_GRASS_CONFIG, 100, CLOVER_CONFIG, 250, THISTLE_CONFIG, 5, NETTLES_CONFIG, 10, FERN_CONFIG, 500);
    public static final DoubleGrassBlend DOUBLE_STANDARD = DoubleGrassBlend.of(DOUBLE_GRASS_CONFIG, 500, DOUBLE_WHEATGRASS_CONFIG, 100);
    public static final DoubleGrassBlend DOUBLE_WITH_FERNS = DoubleGrassBlend.of(DOUBLE_GRASS_CONFIG, 500, DOUBLE_WHEATGRASS_CONFIG, 100, DOUBLE_FERN_CONFIG, 500);
    public static final DoubleGrassBlend DOUBLE_WITH_EXTRA_WHEATGRASS = DoubleGrassBlend.of(DOUBLE_GRASS_CONFIG, 500, DOUBLE_WHEATGRASS_CONFIG, 800);
    public static final DoubleGrassBlend DOUBLE_MOORS = DoubleGrassBlend.of(DOUBLE_GRASS_CONFIG, 500);
    public static final DoubleGrassBlend DOUBLE_MOORS_WITH_FERNS = DoubleGrassBlend.of(DOUBLE_GRASS_CONFIG, 500, DOUBLE_FERN_CONFIG, 500);
    public static final DoubleGrassBlend DOUBLE_WITH_ARID = DoubleGrassBlend.of(DOUBLE_GRASS_CONFIG, 500, DOUBLE_WHEATGRASS_CONFIG, 100, DOUBLE_ARID_GRASS_CONFIG, 550);
    public static final DoubleGrassBlend DOUBLE_MUTED = DoubleGrassBlend.of(DOUBLE_GRASS_CONFIG, 500);
    public static final DoubleGrassBlend DOUBLE_MUTED_WITH_FERNS = DoubleGrassBlend.of(DOUBLE_GRASS_CONFIG, 500, DOUBLE_FERN_CONFIG, 500);

    public static BlockClusterFeatureConfig buildSimpleGrassConfig(Block block, int tries) {
        return new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(block.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(tries).func_227322_d_();
    }

    public static BlockClusterFeatureConfig buildSimpleDoubleGrassConfig(Block block, int tries) {
        return new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(block.func_176223_P()), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(tries).func_227317_b_().func_227322_d_();
    }
}

