/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.layer;

import lotr.common.init.LOTRBiomes;
import lotr.common.world.biome.LOTRBiomeBase;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.layer.traits.ICastleTransformer;
import net.minecraft.world.server.ServerWorld;

public class MEShoreLayers {
    private static boolean isSea(int biomeID, IWorld world) {
        return biomeID == LOTRBiomes.getBiomeID(LOTRBiomes.SEA, world);
    }

    private static boolean isIsland(int biomeID, IWorld world) {
        return biomeID == LOTRBiomes.getBiomeID(LOTRBiomes.ISLAND, world);
    }

    public static enum ForIsland implements ICastleTransformer
    {
        INSTANCE;


        public int func_202748_a(INoiseRandom noiseRand, int north, int east, int south, int west, int center) {
            ServerWorld world = LOTRBiomes.getServerBiomeContextWorld();
            if (MEShoreLayers.isSea(center, (IWorld)world) && (MEShoreLayers.isIsland(north, (IWorld)world) || MEShoreLayers.isIsland(east, (IWorld)world) || MEShoreLayers.isIsland(south, (IWorld)world) || MEShoreLayers.isIsland(west, (IWorld)world))) {
                return LOTRBiomes.getBiomeID(LOTRBiomes.BEACH, (IWorld)world);
            }
            return center;
        }
    }

    public static enum ForMainland implements ICastleTransformer
    {
        INSTANCE;


        public int func_202748_a(INoiseRandom noiseRand, int north, int east, int south, int west, int center) {
            ServerWorld world = LOTRBiomes.getServerBiomeContextWorld();
            if (!MEShoreLayers.isSea(center, (IWorld)world) && !MEShoreLayers.isIsland(center, (IWorld)world) && (MEShoreLayers.isSea(north, (IWorld)world) || MEShoreLayers.isSea(east, (IWorld)world) || MEShoreLayers.isSea(south, (IWorld)world) || MEShoreLayers.isSea(west, (IWorld)world))) {
                Biome centerBiome = LOTRBiomes.getBiomeByID(center, (IWorld)world);
                LOTRBiomeBase shoreBiome = LOTRBiomes.getWrapperFor(centerBiome, (IWorld)world).getShore();
                return LOTRBiomes.getBiomeID(shoreBiome, (IWorld)world);
            }
            return center;
        }
    }
}

