/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import lotr.common.world.gen.tree.ExtendedTrunkPlacer;
import lotr.common.world.gen.tree.LOTRTrunkPlacers;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;

public class BoughsTrunkPlacer
extends ExtendedTrunkPlacer {
    protected static final Codec<BoughsTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> BoughsTrunkPlacer.baseCodecWithWood(instance).apply((Applicative)instance, BoughsTrunkPlacer::new));

    protected BoughsTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, Optional<BlockStateProvider> woodProvider, Optional<BlockStateProvider> strippedLogProvider, Optional<BlockStateProvider> branchProvider) {
        super(baseHeight, heightRandA, heightRandB, woodProvider, strippedLogProvider, branchProvider);
    }

    public BoughsTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, BlockState wood, BlockState branch) {
        this(baseHeight, heightRandA, heightRandB, Optional.of(new SimpleBlockStateProvider(wood)), Optional.empty(), Optional.of(new SimpleBlockStateProvider(branch)));
    }

    protected TrunkPlacerType<?> func_230381_a_() {
        return LOTRTrunkPlacers.BOUGHS_TRUNK_PLACER;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader world, Random rand, int trunkHeight, BlockPos basePos, Set<BlockPos> trunk, MutableBoundingBox bb, BaseTreeFeatureConfig config) {
        BoughsTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)basePos.func_177977_b());
        for (int y = 0; y < trunkHeight; ++y) {
            BoughsTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)basePos.func_177981_b(y), trunk, (MutableBoundingBox)bb, (BaseTreeFeatureConfig)config);
        }
        int branchMinHeight = (int)((float)trunkHeight * 0.6f);
        int branchMaxHeight = trunkHeight - 1;
        this.placeWood(world, rand, basePos.func_177981_b(branchMaxHeight), trunk, bb, config, Direction.Axis.Y);
        ArrayList<FoliagePlacer.Foliage> foliage = new ArrayList<FoliagePlacer.Foliage>();
        int deg = 0;
        for (int y = branchMaxHeight; y >= branchMinHeight; --y) {
            int branches = 1 + rand.nextInt(2);
            for (int b = 0; b < branches; ++b) {
                float angle = (float)Math.toRadians(deg += 50 + rand.nextInt(70));
                float cos = MathHelper.func_76134_b((float)angle);
                float sin = MathHelper.func_76126_a((float)angle);
                float angleY = rand.nextFloat() * (float)Math.toRadians(40.0);
                float cosY = MathHelper.func_76134_b((float)angleY);
                float sinY = MathHelper.func_76126_a((float)angleY);
                int length = 4 + rand.nextInt(6);
                BlockPos.Mutable branchPos = new BlockPos.Mutable().func_239621_a_((Vector3i)basePos, 0, y, 0);
                Direction.Axis branchAxis = Direction.func_176733_a((double)(deg + 90)).func_176740_k();
                for (int l = 0; l < length; ++l) {
                    if (Math.floor(cos * (float)l) != Math.floor(cos * (float)(l - 1))) {
                        branchPos.func_196234_d((int)Math.signum(cos), 0, 0);
                    }
                    if (Math.floor(sin * (float)l) != Math.floor(sin * (float)(l - 1))) {
                        branchPos.func_196234_d(0, 0, (int)Math.signum(sin));
                    }
                    if (Math.floor(sinY * (float)l) != Math.floor(sinY * (float)(l - 1))) {
                        branchPos.func_196234_d(0, (int)Math.signum(sinY), 0);
                    }
                    if (branchPos.func_177958_n() == basePos.func_177958_n() && branchPos.func_177952_p() == basePos.func_177952_p() && branchPos.func_177956_o() <= basePos.func_177956_o() + branchMaxHeight) continue;
                    if (!TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)branchPos)) break;
                    this.placeWood(world, rand, (BlockPos)branchPos, trunk, bb, config, branchAxis);
                }
                foliage.add(new FoliagePlacer.Foliage(branchPos.func_177981_b(2), rand.nextInt(2), false));
            }
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            int rootUp = rand.nextInt(3);
            int rootLength = 3 + rootUp + rand.nextInt(3);
            int maxOut = 1;
            if (rootUp >= 2 && rand.nextBoolean()) {
                ++maxOut;
            }
            BlockPos.Mutable rootPos = new BlockPos.Mutable().func_239621_a_((Vector3i)basePos, dir.func_82601_c(), rootUp, dir.func_82599_e());
            this.growRootsDownAndThenOut(world, rand, rootPos, rootLength, dir, maxOut, trunk, bb, config);
        }
        return foliage;
    }
}

