/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import lotr.common.world.gen.tree.ExtendedTrunkPlacer;
import lotr.common.world.gen.tree.LOTRTrunkPlacers;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;

public class CedarTrunkPlacer
extends ExtendedTrunkPlacer {
    protected static final Codec<CedarTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> CedarTrunkPlacer.baseCodecWithWood(instance).apply((Applicative)instance, CedarTrunkPlacer::new));

    protected CedarTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, Optional<BlockStateProvider> woodProvider, Optional<BlockStateProvider> strippedLogProvider, Optional<BlockStateProvider> branchProvider) {
        super(baseHeight, heightRandA, heightRandB, woodProvider, strippedLogProvider, branchProvider);
    }

    public CedarTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, BlockState branch) {
        this(baseHeight, heightRandA, heightRandB, Optional.empty(), Optional.empty(), Optional.of(new SimpleBlockStateProvider(branch)));
    }

    protected TrunkPlacerType<?> func_230381_a_() {
        return LOTRTrunkPlacers.CEDAR_TRUNK_PLACER;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader world, Random rand, int trunkHeight, BlockPos basePos, Set<BlockPos> trunk, MutableBoundingBox bb, BaseTreeFeatureConfig config) {
        CedarTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)basePos.func_177977_b());
        for (int y = 0; y < trunkHeight; ++y) {
            CedarTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)basePos.func_177981_b(y), trunk, (MutableBoundingBox)bb, (BaseTreeFeatureConfig)config);
        }
        ArrayList<FoliagePlacer.Foliage> foliage = new ArrayList<FoliagePlacer.Foliage>();
        foliage.add(new FoliagePlacer.Foliage(basePos.func_177981_b(trunkHeight), 0, false));
        for (int y = trunkHeight - 1; y > trunkHeight / 2; y -= 1 + rand.nextInt(3)) {
            int branches = 1 + rand.nextInt(3);
            block2: for (int b = 0; b < branches; ++b) {
                float angle = rand.nextFloat() * (float)Math.PI * 2.0f;
                int length = MathHelper.func_76136_a((Random)rand, (int)4, (int)7);
                int leafLayerLessWidth = 1;
                BlockPos.Mutable branchPos = new BlockPos.Mutable();
                for (int l = 0; l < length; ++l) {
                    int branchX = Math.round(0.5f + MathHelper.func_76134_b((float)angle) * (float)(l + 1));
                    int branchZ = Math.round(0.5f + MathHelper.func_76126_a((float)angle) * (float)(l + 1));
                    int branchY = y - 3 + l / 2;
                    BlockPos prevBranchPos = branchPos.func_185334_h();
                    branchPos.func_239621_a_((Vector3i)basePos, branchX, branchY, branchZ);
                    if (branchPos.equals((Object)prevBranchPos)) continue;
                    if (!CedarTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)branchPos, trunk, (MutableBoundingBox)bb, (BaseTreeFeatureConfig)config)) continue block2;
                    if (l != length - 1 || leafLayerLessWidth > 1) continue;
                    BlockPos.Mutable woodPos = new BlockPos.Mutable();
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            if (x != 0 && z != 0 || x == z) continue;
                            woodPos.func_239621_a_((Vector3i)branchPos, x, 0, z);
                            CedarTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)woodPos, trunk, (MutableBoundingBox)bb, (BaseTreeFeatureConfig)config);
                        }
                    }
                }
                foliage.add(new FoliagePlacer.Foliage(branchPos.func_177984_a(), -leafLayerLessWidth, false));
            }
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (Math.abs(x) == Math.abs(z)) continue;
                BlockPos.Mutable rootPos = new BlockPos.Mutable().func_239621_a_((Vector3i)basePos, x, rand.nextInt(2), z);
                int rootLength = 4 + rand.nextInt(3);
                this.growRootsDown(world, rand, rootPos, rootLength, trunk, bb, config);
            }
        }
        return foliage;
    }
}

