/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import lotr.common.world.gen.tree.ExtendedTrunkPlacer;
import lotr.common.world.gen.tree.LOTRTrunkPlacers;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;

public class DesertTrunkPlacer
extends ExtendedTrunkPlacer {
    protected static final Codec<DesertTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> DesertTrunkPlacer.baseCodecWithWood(instance).apply((Applicative)instance, DesertTrunkPlacer::new));

    protected DesertTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, Optional<BlockStateProvider> woodProvider, Optional<BlockStateProvider> strippedLogProvider, Optional<BlockStateProvider> branchProvider) {
        super(baseHeight, heightRandA, heightRandB, woodProvider, strippedLogProvider, branchProvider);
    }

    public DesertTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, BlockState wood) {
        this(baseHeight, heightRandA, heightRandB, Optional.of(new SimpleBlockStateProvider(wood)), Optional.empty(), Optional.empty());
    }

    protected TrunkPlacerType<?> func_230381_a_() {
        return LOTRTrunkPlacers.DESERT_TRUNK_PLACER;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader world, Random rand, int trunkHeight, BlockPos basePos, Set<BlockPos> trunk, MutableBoundingBox bb, BaseTreeFeatureConfig config) {
        DesertTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)basePos.func_177977_b());
        for (int y = 0; y < trunkHeight; ++y) {
            DesertTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)basePos.func_177981_b(y), trunk, (MutableBoundingBox)bb, (BaseTreeFeatureConfig)config);
        }
        ArrayList<FoliagePlacer.Foliage> foliage = new ArrayList<FoliagePlacer.Foliage>();
        int trunkTopOffset = 0;
        int branches = 4;
        for (Direction branchDir : Direction.Plane.HORIZONTAL) {
            int branchLength = 1 + rand.nextInt(3);
            int branchHeight = trunkHeight - trunkTopOffset - 1 - rand.nextInt(2);
            BlockPos.Mutable branchPos = new BlockPos.Mutable().func_239621_a_((Vector3i)basePos, 0, branchHeight, 0);
            for (int l = 0; l < branchLength; ++l) {
                if (rand.nextInt(3) != 0) {
                    branchPos.func_189536_c(Direction.UP);
                }
                if (rand.nextInt(3) != 0) {
                    branchPos.func_189536_c(branchDir);
                }
                if (!DesertTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)branchPos, trunk, (MutableBoundingBox)bb, (BaseTreeFeatureConfig)config)) break;
            }
            foliage.add(new FoliagePlacer.Foliage(branchPos.func_177984_a(), 0, false));
        }
        return foliage;
    }
}

